<h2>Why is this an issue?</h2>
<p>The TypeScript programming language supports <em>generics</em>, a programming construct for creating reusable components, that is, components that
can work over various types rather than a single one. Sometimes, we need to limit this genericity to a specific set of types, typically when we know
these types share common capabilities, e.g., a <code>length</code> property. To this end, the language provides the <code>extends</code> clause to
describe type constraints on type parameters, whether for classes, interfaces, type aliases, or functions.</p>
<p>By default, a type parameter extends the <code>any</code> type. It is therefore redundant to explicitly extend from <code>any</code> and should be
removed accordingly.</p>
<h2>How to fix it</h2>
<p>Fixing such an issue involves removing the redundant type constraint to <code>any</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
class C<T extends any> {
    // ...
}
```
<h4>Compliant solution</h4>

```ts
class C<T> {
    // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/generics.html">Generics</a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/2/generics.html#generic-constraints">Generic Constraints</a>
  </li>
</ul>