<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>This rule checks that the values of ARIA attributes "aria-*" in DOM elements are valid.</p>
<h2>How to fix</h2>
<p>Check that each element with a defined ARIA attribute has a valid value.</p>

```ts
<span aria-hidden="ok">foo</span>
```
<p>To fix the code use a valid value for the aria-* attribute.</p>

```ts
<span aria-hidden="true">foo</span>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes">ARIA states and properties (Reference)</a>
  </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
</ul>