# Discouraged Direct Initialization

Discouraged direct initialization of types that can be harmful.

* **Identifier:** discouraged_direct_init
* **Supports autocorrection:** No
* **Kind:** lint
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning, types: ["Bundle", "Bundle.init", "UIDevice", "UIDevice.init"]

## Non Triggering Examples

```swift
let foo = UIDevice.current
```

```swift
let foo = Bundle.main
```

```swift
let foo = Bundle(path: "bar")
```

```swift
let foo = Bundle(identifier: "bar")
```

```swift
let foo = Bundle.init(path: "bar")
```

```swift
let foo = Bundle.init(identifier: "bar")
```

## Triggering Examples

```swift
↓UIDevice()
```

```swift
↓Bundle()
```

```swift
let foo = ↓UIDevice()
```

```swift
let foo = ↓Bundle()
```

```swift
let foo = bar(bundle: ↓Bundle(), device: ↓UIDevice())
```

```swift
↓UIDevice.init()
```

```swift
↓Bundle.init()
```

```swift
let foo = ↓UIDevice.init()
```

```swift
let foo = ↓Bundle.init()
```

```swift
let foo = bar(bundle: ↓Bundle.init(), device: ↓UIDevice.init())
```