# Prefer Self in Static References

Static references should be prefixed by `Self` instead of the class name.

* **Identifier:** prefer_self_in_static_references
* **Supports autocorrection:** Yes
* **Kind:** style
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** N/A

## Non Triggering Examples

```swift
    class C {
        static private(set) var i = 0, j = C.i
        let h = C.i
        @GreaterThan(C.j) var k: Int
    }
```

```swift
    class `Self` {
        static let i = 0
        func f() -> Int { Self.i }
    }
```

```swift
    class S {
        static func f() { Self.g(Self.f) }
        static func g(f: () -> Void) { f() }
    }
```

```swift
    struct T {
        static let i = 0
    }
    struct S {
        static let i = 0
    }
    extension T {
        static let j = S.i + Self.i
    }
```

```swift
    struct S {
        struct T {
            struct R {
                static let i = 3
            }
        }
        struct R {
            static let j = S.T.R.i
        }
        static let j = Self.T.R.i + Self.R.j
        let h = Self.T.R.i + Self.R.j
    }
```

```swift
    class C {
        static let s = 2
        func f(i: Int = C.s) -> Int {
            func g(@GreaterEqualThan(C.s) j: Int = C.s) -> Int { j }
            return i + Self.s
        }
    }
```

## Triggering Examples

```swift
    struct C {
        static let i = 0
        static let j = ↓C.i
    }
```

```swift
    struct S {
        static let i = 0
        func f() -> Int { ↓S.i }
    }
```

```swift
    class C {
        struct S {
            static let i = 2
            let h = ↓S.i
        }
        static let i = 1
        let h = C.i
    }
```

```swift
    struct S {
        struct T {
            static let i = 3
        }
        struct R {
            static let j = S.T.i
        }
        static let h = ↓S.T.i + ↓S.R.j
    }
```