# Redundant Void Return

Returning Void in a function declaration is redundant.

* **Identifier:** redundant_void_return
* **Supports autocorrection:** Yes
* **Kind:** idiomatic
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 3.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
func foo() {}

```

```swift
func foo() -> Int {}

```

```swift
func foo() -> Int -> Void {}

```

```swift
func foo() -> VoidResponse

```

```swift
let foo: (Int) -> Void

```

```swift
func foo() -> Int -> () {}

```

```swift
let foo: (Int) -> ()

```

```swift
func foo() -> ()?

```

```swift
func foo() -> ()!

```

```swift
func foo() -> Void?

```

```swift
func foo() -> Void!

```

```swift
struct A {
    subscript(key: String) {
        print(key)
    }
}
```

## Triggering Examples

```swift
func foo()↓ -> Void {}

```

```swift
protocol Foo {
  func foo()↓ -> Void
}
```

```swift
func foo()↓ -> () {}

```

```swift
func foo()↓ -> ( ) {}
```

```swift
protocol Foo {
  func foo()↓ -> ()
}
```