@echo off

REM Usage teamscale.bat [-c <path-to-teamscale-config.properties>]

REM Used to scope JAVA_OPTS only for the next two calls
setlocal
if not defined TEAMSCALE_HOME set TEAMSCALE_HOME=%~dp0
set JAVA_OPTS=-fullversion

for /f "delims=" %%j in ('"%TEAMSCALE_HOME%\bin\Teamscale.bat" 2^>^&1') do set "JAVA_VERSION=%%j"
for /f tokens^=2-5^ delims^=.-_^" %%j in ('"%TEAMSCALE_HOME%\bin\Teamscale.bat" 2^>^&1') do set "JAVA_MAJOR_VERSION=%%j"

if "%JAVA_MAJOR_VERSION%" LSS "21" (
	echo Teamscale requires a minimum java version of 21, but you tried to execute it with '%JAVA_VERSION%'.
	exit /B 2
)
endlocal

setlocal

REM Replaced during build with actual version
set VERSION=2025.7.12
IF "%VERSION:~0,1%"=="@" (
  title "%~dpn0"
) else (
  title Teamscale %VERSION%
)

REM - set TEAMSCALE_HOME to execution directory if not defined
if not defined TEAMSCALE_HOME set TEAMSCALE_HOME=%~dp0

REM - load JVM properties
if not defined TEAMSCALE_CONFIG__JVM_PROPERTIES if defined TEAMSCALE_CONFIG if exist "%TEAMSCALE_CONFIG%\jvm.properties" (
	set TEAMSCALE_CONFIG__JVM_PROPERTIES=%TEAMSCALE_CONFIG%\jvm.properties
)
if not defined TEAMSCALE_CONFIG__JVM_PROPERTIES if exist "%CD%\config\jvm.properties" (
	set TEAMSCALE_CONFIG__JVM_PROPERTIES=%CD%\config\jvm.properties
)
if not defined TEAMSCALE_CONFIG__JVM_PROPERTIES if exist "%TEAMSCALE_HOME%\config\jvm.properties" (
	set TEAMSCALE_CONFIG__JVM_PROPERTIES=%TEAMSCALE_HOME%\config\jvm.properties
)
if exist "%TEAMSCALE_CONFIG__JVM_PROPERTIES%" for /f "usebackq delims== tokens=1* eol=#" %%G in ("%TEAMSCALE_CONFIG__JVM_PROPERTIES%") do set %%G=%%H

if not defined TEAMSCALE_MEMORY set TEAMSCALE_MEMORY=%JVM_MEMORY%
if not defined TEAMSCALE_MEMORY set TEAMSCALE_MEMORY=4096m

if defined TEAMSCALE_TEMP (
        if not exist "%TEAMSCALE_TEMP%" mkdir "%TEAMSCALE_TEMP%"
        set TEAMSCALE_TEMP="-Djava.io.tmpdir=%TEAMSCALE_TEMP%"
) else set TEAMSCALE_TEMP=

if not defined TEAMSCALE_OPTS set TEAMSCALE_OPTS=
if not defined TEAMSCALE_VM_ARGS set TEAMSCALE_VM_ARGS=
if not defined JVM_EXTRA_ARGS set JVM_EXTRA_ARGS=
set TEAMSCALE_OPTS=-Xmx%TEAMSCALE_MEMORY% %TEAMSCALE_TEMP% %TEAMSCALE_OPTS%  %TEAMSCALE_VM_ARGS% %JVM_EXTRA_ARGS%

call "%TEAMSCALE_HOME%\bin\Teamscale.bat" %*

endlocal
