Overly long files hamper program comprehension and have a negative influence on maintainability.
Extract functionality that relates to similar concerns into their own files.

# What Does This Check Look For?

This check counts the length of files in Source Lines of Code (SLOC), that is, all lines that are not empty or comments.

Depending on the analysis profile configuration, this check produces yellow findings for lengthy files (default: longer than 300 SLOC) and red findings for very long files (default: longer than 750 SLOC).

# Why is This a Problem?

Long files can complicate both locating a specific feature within a file and understanding the consequences of a change.
This hampers the understandability and maintainability of the code.

Additionally, long files hint at multiple or overly broad responsibilities.
Ideally, a file should contain a clearly defined set of features.
Very long files often indicate that too many features are intermixed in the code.

There is also some evidence that file size has an impact on the likelihood of the file containing a defect.

# How Can I Resolve This?

File size can best be reduced by extracting functionality that relates to similar features or concerns into other files.
It is important that the reduction should not be performed only syntactically (for example, by folding all lines into a single line or using a preprocessor for splitting the files) as this can actually further decrease the understandability. 

# Where Can I Learn More?

* [Teamscale Documentation: What Makes Maintainable Code? - Code Structure](https://docs.teamscale.com/introduction/understanding-the-maintainability-of-your-code-base/#code-structure)
* [Measuring program comprehension: A large-scale field study with professionals](https://xin-xia.github.io/publication/TSE17.pdf)
* [An Exploratory Study of the Impact of Antipatterns on Class Change- and Fault-Proneness](https://link.springer.com/article/10.1007/s10664-011-9171-y)
* [High-Impact Defects: A Study of Breakage and Surprise Defects](https://dl.acm.org/doi/pdf/10.1145/2025113.2025155?casa_token=muCBy672jawAAAAA:G6chWMIShQEgME0WdnZ3BSaemWnQTSs80wGdlFt5Ujj7tR2iWghbGe5s9UahILvfDWA_iSNgtEqS)
* [Quantifying the Effect of Code Smells on Maintenance Effort](https://ieeexplore.ieee.org/document/6392174/)
