Generically catching all exceptions via the exception base class `CX_ROOT` is a quick 
way to get to a first working draft of code. It can help achieving results quickly 
during prototyping. In production code, however, this approach can lead to programming errors being unnoticed, 
because exceptions hinting at such cases are caught as well when catching `CX_ROOT`.

Therefore, only exceptions declared by the called methods should be included in `CATCH` 
blocks.

# What Does This Check Look For?

This check searches for explicit usage of the type `CX_ROOT` in the `CATCH` clause of 
a `TRY...CATCH` block. 

# Why is This a Problem?

Catching `CX_ROOT` will also catch dynamic exceptions that usually hint at programming
errors, like `CX_SY_REF_IS_INITIAL` or `CX_SY_ITAB_LINE_NOT_FOUND`. For exceptions like
these, often the underlying code has to be corrected, so that these are not thrown in 
the first place. If they are caught as part of catching `CX_ROOT`, the underlying issue
may go unnoticed for a long time.

# How Can I Resolve This?

Since static and dynamic exceptions must be explicitly declared in method signatures if 
a method can throw them, you can always explicitly list the types of these exceptions in 
the `CATCH` clause instead. 

# Examples
## Non-Compliant

```ABAP
TRY.
  cls=>meth( ).
CATCH cx_root.
  " error handling code
ENDTRY.
```

## Compliant

```ABAP
TRY.
  cls=>meth( ).
CATCH zcx_my_application_exception.
  " error handling code
ENDTRY.
```

# Where Can I Learn More?

- [code pal for ABAP: CX_ROOT Usage](https://github.com/SAP/code-pal-for-abap/blob/master/docs/checks/cx-root-usage.md)
