The declaration of the defined method/attribute is not visible for the compiler.
Make sure that the declaration of it accessible to this code.

# What Does This Check Look For?

This check searches for **globally scoped** methods/attributes and checks whether they have been declared before they are defined.
If they are not, this check reports a finding.

# Why is This a Problem?

A compiler must check whether the declaration and definition of an object or function are compatible. 
In order for it to do so, the declaration must be accessible when checking the definition.

# How Can I Resolve This?

Declare objects and functions with external linkage in a header file and then include the header file in the code files that need them.

# Examples
## Non-Compliant

```cpp
extern uint8_t someInteger = 100u;  // non-compliant: no declaration prior to this definition
uint8_t otherInteger = 90u;         // non-compliant: no declaration prior to this definition

void someFunction() {
  // non-compliant: no declaration prior to this definition
}
```

## Compliant

```cpp
extern uint8_t someInteger;
uint8_t someInteger = 100u;   // compliant: variable was declared before

extern void someFunction ();
void someFunction() {
  // compliant: method was declared before
}

static void otherFunction () {
  // compliant: method has internal linkage
}
```

# Where Can I Learn More?
- Guideline: MISRA C:2012: 8.4 - A compatible declaration shall be visible when an object or function with external linkage is defined