Explicitly importing types from `java.lang` is unnecessary as they are included by default.
Consider removing explicit imports of `java.lang` types to improve code clarity and avoid redundancy.

# What Does This Check Look For?

This check searches for explicit imports from the `java.lang` package.

# Why is This a Problem?

Explicitly importing types from `java.lang` is considered redundant, as all types from this package are available by default in every Java file.
This redundancy can lead to unnecessary clutter in the import section of Java files, potentially making them harder to read and maintain.

# How Can I Resolve This?

Simply remove any explicit import statements from `java.lang`. The Java compiler automatically includes these by default, so your code will still compile, and it will be cleaner and more maintainable.

# Examples

## Non-Compliant

```java
import java.lang.String;

public class Example {
    String exampleString = "Hello, world!";
}
```

## Compliant

```java
public class Example {
    String exampleString = "Hello, world!";
}
```
