The execution of executable classes, like application jobs or console applications, could expose critical operations or sensitive data if the main entry point method does not perform an **AUTHORITY-CHECK** .
Always ensure that an **AUTHORITY-CHECK** is properly implemented at the start of the main entry point to validate user permissions.

# What Does This Check Look For?

This check identifies main entry point methods of executable classes, such as application jobs or console applications, that do not start with an explicit `AUTHORITY-CHECK`.

# Why is This a Problem?

Lacking `AUTHORITY-CHECK` in methods of executable classes can lead to security vulnerabilities, as unauthorized users might execute operations or access data they should not have access to.
Thus, ensuring that the method performs its own authority checks is essential for maintaining both data integrity and the security of the application.

# How Can I Resolve This?

To address this issue, insert an `AUTHORITY-CHECK` statement at the beginning of the method.
This will verify the user's permissions against the specified authorization object before executing any further action.
If you're utilizing custom authority check procedures, make sure they encapsulate the `AUTHORITY-CHECK` statement effectively, and set them up in the analysis profile to prevent false positives.
(If you don't have the required permissions to change Teamscale's analysis profile, please reach out to your Teamscale support person.)

# Examples

## Non-Compliant

```abap
CLASS lcl_executable_class DEFINITION.
  PUBLIC SECTION.
    INTERFACES: IF_APJ_DT_EXEC_OBJECT.
ENDCLASS.

CLASS lcl_executable_class IMPLEMENTATION.
  METHOD IF_APJ_DT_EXEC_OBJECT~execute.
    WRITE 'Performing sensitive operations'.
  ENDMETHOD.
ENDCLASS.
```

## Compliant

```abap
CLASS lcl_executable_class DEFINITION.
  PUBLIC SECTION.
    INTERFACES: IF_APJ_DT_EXEC_OBJECT.
ENDCLASS.

CLASS lcl_executable_class IMPLEMENTATION.
  METHOD IF_APJ_DT_EXEC_OBJECT~execute.
    AUTHORITY-CHECK OBJECT 'S_PROGRAM'
      ID 'ACTVT' FIELD '02'.
    IF sy-subrc = 0.
      WRITE 'Performing sensitive operations'.
    ENDIF.
  ENDMETHOD.
ENDCLASS.
```

# Where Can I Learn More?

- [ABAP - Keyword Documentation: AUTHORITY-CHECK](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenbc_authority_check.htm)
