This check flags overloaded variables names.

# Why is This a Problem?
Reusing variable names in different contexts reduces code clarity. 
Unique variable names enhance code readability and maintainability.

# How Can I Resolve This?

Rename overloaded variable names to make them unique.

# Examples
## Non-Compliant
```oraclesqlplus
begin
    <<main>>
        declare
        co_main    constant user_objects.object_name%type := 'test_main';
        co_sub     constant user_objects.object_name%type := 'test_sub';
        co_sep     constant user_objects.object_name%type := ' - ';
        l_variable user_objects.object_name%type          := co_main;
    begin
        <<sub>>
            declare
            l_variable user_objects.object_name%type := co_sub;
        begin
            sys.dbms_output.put_line(l_variable
                || co_sep
                || main.l_variable);
        end sub;
    end main;
end;
/
```

## Compliant
```oraclesqlplus
begin
    <<main>>
        declare
        co_main         constant user_objects.object_name%type := 'test_main';
        co_sub          constant user_objects.object_name%type := 'test_sub';
        co_sep          constant user_objects.object_name%type := ' - ';
        l_main_variable user_objects.object_name%type          := co_main;
    begin
        <<sub>>
            declare
            l_sub_variable user_objects.object_name%type := co_sub;
        begin
            sys.dbms_output.put_line(l_sub_variable
                || co_sep
                || l_main_variable);
        end sub;
    end main;
end;
/
```

# Where Can I Learn More?
- [G-2170: Never overload variables](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.2/4-language-usage/2-variables-and-types/1-general/g-2170/)