<h2>Why is this an issue?</h2>
<p>The Spring framework provides the annotation <code>Async</code> to mark a method (or all methods of a type) as a candidate for asynchronous
execution.</p>
<p>Asynchronous methods do not necessarily, by their nature, return the result of their calculation immediately. Hence, it is unexpected and in clear
breach of the <code>Async</code> contract for such methods to have a return type that is neither <code>void</code> nor a <code>Future</code> type.</p>
<h2>How to fix it</h2>
<p>Use <code>void</code> as the return type if the method is not expected to return a result. Otherwise, a <code>Future</code> should be returned,
allowing the caller to retrieve the result once it is ready. It is permitted to return more specific subtypes that inherit from
<code>Future</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
@Async
public String asyncMethod() {
  ...
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
@Async
public Future&lt;String&gt; asyncMethod() {
  ...
}
</pre>
<p>Alternatively, if the method does not need to return a result:</p>
<pre>
@Async
public void asyncMethod() {
  ...
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Spring Framework Documentation - <a
  href="https://docs.spring.io/spring-framework/docs/current/javadoc-api/org/springframework/scheduling/annotation/Async.html">Annotation Interface
  Async</a> </li>
</ul>