/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.jetbrains.annotations.VisibleForTesting;

public final class RollingListIndex<T>
implements IUtilityIndex {
    private final SimpleCrudIndex<Integer, T> valueIndex;
    private final SimpleCrudIndex<EMetaKey, Integer> metaIndex;
    private final int defaultMaxSize;

    public RollingListIndex(IStore store, ISerializer<T, byte[]> valueSerializer, int defaultMaxSize) {
        Preconditions.checkArgument((defaultMaxSize >= 0 ? 1 : 0) != 0, (String)"defaultMaxSize (%s) must be non-negative", (int)defaultMaxSize);
        this.defaultMaxSize = defaultMaxSize;
        this.valueIndex = new SimpleCrudIndex<Integer, T>(new DelegatingPartitionStore(store, "values"), ISerializer.forInteger(), valueSerializer);
        this.metaIndex = new SimpleCrudIndex<EMetaKey, Integer>(new DelegatingPartitionStore(store, "meta"), ISerializer.forEnumOrdinal(EMetaKey.class), ISerializer.forInteger());
    }

    @VisibleForTesting
    int getFirst() throws StorageException {
        return this.metaIndex.get(EMetaKey.FIRST).orElse(0);
    }

    @VisibleForTesting
    void setFirst(int first) throws StorageException {
        this.metaIndex.put(EMetaKey.FIRST, first);
    }

    private int getElementCount() throws StorageException {
        return this.metaIndex.get(EMetaKey.COUNT).orElse(0);
    }

    private void setElementCount(int high) throws StorageException {
        this.metaIndex.put(EMetaKey.COUNT, high);
    }

    public int getMaxSize() throws StorageException {
        return this.metaIndex.get(EMetaKey.MAX_SIZE).orElse(this.defaultMaxSize);
    }

    public void setMaxSize(int maxSize) throws StorageException {
        Preconditions.checkArgument((maxSize >= 0 ? 1 : 0) != 0, (String)"maxSize (%s) must be non-negative", (int)maxSize);
        this.metaIndex.put(EMetaKey.MAX_SIZE, maxSize);
        this.trimToSize(maxSize);
    }

    public void appendElements(List<T> elements) throws StorageException {
        if (elements.isEmpty()) {
            return;
        }
        int maxSize = this.getMaxSize();
        if (elements.size() > maxSize) {
            elements = elements.subList(elements.size() - maxSize, elements.size());
        }
        int first = this.getFirst();
        int count = this.getElementCount();
        int next = first + count;
        for (T element : elements) {
            this.valueIndex.put(next++, element);
        }
        int currentSize = next - first;
        this.setElementCount(currentSize);
        if (currentSize > maxSize) {
            this.trimToSize(maxSize);
        }
    }

    public List<T> getElements() throws StorageException {
        int first = this.getFirst();
        int count = this.getElementCount();
        ArrayList<T> elements = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            elements.add(this.valueIndex.get(first + i).orElseThrow());
        }
        return elements;
    }

    private void trimToSize(int maxSize) throws StorageException {
        int currentSize = this.getElementCount();
        if (currentSize <= maxSize) {
            return;
        }
        int first = this.getFirst();
        while (currentSize > maxSize) {
            this.valueIndex.remove(first++);
            --currentSize;
        }
        this.setFirst(first);
        this.setElementCount(currentSize);
    }

    @Override
    public IStore getWrappedStore() {
        return this.valueIndex.getWrappedStore(DelegatingPartitionStore.class).getBaseStore();
    }

    private static enum EMetaKey {
        FIRST,
        COUNT,
        MAX_SIZE;

    }
}

