/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.ThreadSafe;

public abstract class HistorizingStoreBase
implements IStore {
    public static final String HEAD_PREFIX_STRING = "#_HEAD_#";
    protected static final byte[] HEAD_PREFIX = "#_HEAD_#".getBytes(StandardCharsets.UTF_8);
    protected static final byte[] DELETION_MARKER = new byte[]{0};
    protected static final byte TIMESTAMP_SEPARATOR = -2;
    protected final IStore store;

    protected HistorizingStoreBase(IStore delegate) {
        this.store = delegate;
    }

    protected static byte[] headKey(byte[] key) {
        if (key == null) {
            return HEAD_PREFIX;
        }
        byte[] newKey = new byte[key.length + HEAD_PREFIX.length];
        System.arraycopy(HEAD_PREFIX, 0, newKey, 0, HEAD_PREFIX.length);
        System.arraycopy(key, 0, newKey, HEAD_PREFIX.length, key.length);
        return newKey;
    }

    protected static List<byte[]> headKeyList(List<byte[]> keys) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (byte[] key : keys) {
            result.add(HistorizingStoreBase.headKey(key));
        }
        return result;
    }

    private static byte[] stripHeadPrefix(byte[] key) {
        byte[] newKey = new byte[key.length - HEAD_PREFIX.length];
        System.arraycopy(key, HEAD_PREFIX.length, newKey, 0, newKey.length);
        return newKey;
    }

    public static byte[] stripTimestampSuffix(byte[] key) {
        return Arrays.copyOf(key, key.length - 1 - 8);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        HistorizingStoreBase.throwWritingNotSupported();
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        HistorizingStoreBase.throwWritingNotSupported();
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        HistorizingStoreBase.throwWritingNotSupported();
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        HistorizingStoreBase.throwWritingNotSupported();
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        HistorizingStoreBase.throwWritingNotSupported();
    }

    private static void throwWritingNotSupported() throws StorageException {
        throw new StorageException("Operation not supported by this read-only store!");
    }

    public static byte[] revisionKey(byte[] key, byte[] timestampSuffix) {
        byte[] newKey = new byte[key.length + 1 + timestampSuffix.length];
        System.arraycopy(key, 0, newKey, 0, key.length);
        newKey[key.length] = -2;
        System.arraycopy(timestampSuffix, 0, newKey, key.length + 1, timestampSuffix.length);
        return newKey;
    }

    public static boolean isDeletionValue(byte[] value) {
        return Arrays.equals(value, DELETION_MARKER);
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.store.obtainLock(suffix);
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.store.getCapability(capability);
    }

    @ThreadSafe
    protected static final class HeadStrippingCallback
    implements IKeyValueCallback {
        private final IKeyValueCallback delegate;

        public HeadStrippingCallback(IKeyValueCallback callback) {
            this.delegate = callback;
        }

        @Override
        public void callback(byte[] key, byte[] value) {
            this.delegate.callback(HistorizingStoreBase.stripHeadPrefix(key), value);
        }
    }
}

