/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.leveldb;

import com.google.common.primitives.UnsignedBytes;
import java.util.Comparator;
import leveldb.LevelDB;
import leveldb.SWIGTYPE_p_leveldb_iterator_t;
import leveldb.SWIGTYPE_p_leveldb_readoptions_t;
import leveldb.SWIGTYPE_p_leveldb_t;
import leveldb.SWIGTYPE_p_leveldb_writeoptions_t;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.BatchHandlingStoreBase;
import org.conqat.engine.persistence.store.leveldb.LevelDBStorageSystemProvider;

class LevelDBStore
extends BatchHandlingStoreBase {
    private static boolean isInitialized = false;
    private static SWIGTYPE_p_leveldb_readoptions_t readOptions;
    private static SWIGTYPE_p_leveldb_writeoptions_t writeOptions;
    private final SWIGTYPE_p_leveldb_t db;
    private final LevelDBStorageSystemProvider storageSystemProvider;
    private static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR;

    public LevelDBStore(SWIGTYPE_p_leveldb_t db, LevelDBStorageSystemProvider storageSystemProvider) {
        super(new LocalLockProvider());
        LevelDBStore.initStatics();
        this.db = db;
        this.storageSystemProvider = storageSystemProvider;
    }

    private static synchronized void initStatics() {
        if (isInitialized) {
            return;
        }
        readOptions = LevelDB.leveldb_readoptions_create();
        writeOptions = LevelDB.leveldb_writeoptions_create();
        isInitialized = true;
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        this.throwIfShutdown();
        LevelDBStore.throwIfKeyIsNull(key);
        String[] error = new String[1];
        byte[][] result = new byte[][]{null};
        LevelDB.leveldb_get2((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_readoptions_t)readOptions, (byte[])key, (byte[][])result, (String[])error);
        LevelDBStorageSystemProvider.checkError(error);
        return result[0];
    }

    private void throwIfShutdown() throws StorageException {
        if (this.storageSystemProvider.isShutdown()) {
            throw new StorageException("Can not execute a method on a closed storage system!");
        }
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.throwIfShutdown();
        LevelDBStore.throwIfKeyIsNull(key);
        if (value == null) {
            throw new StorageException("Cannot persist null values!");
        }
        String[] error = new String[1];
        LevelDB.leveldb_put((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_writeoptions_t)writeOptions, (byte[])key, (byte[])value, (String[])error);
        LevelDBStorageSystemProvider.checkError(error);
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.throwIfShutdown();
        LevelDBStore.throwIfKeyIsNull(key);
        String[] error = new String[1];
        LevelDB.leveldb_delete((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_writeoptions_t)writeOptions, (byte[])key, (String[])error);
        LevelDBStorageSystemProvider.checkError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.throwIfShutdown();
        byte[] endKey = LevelDBStore.generateEndKey(prefix);
        SWIGTYPE_p_leveldb_iterator_t iterator = LevelDB.leveldb_create_iterator((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_readoptions_t)readOptions);
        try {
            LevelDB.leveldb_iter_seek((SWIGTYPE_p_leveldb_iterator_t)iterator, (byte[])prefix);
            byte[][] key = new byte[][]{null};
            String[] error = new String[1];
            while (LevelDB.leveldb_iter_valid((SWIGTYPE_p_leveldb_iterator_t)iterator) != 0) {
                LevelDB.leveldb_iter_key2((SWIGTYPE_p_leveldb_iterator_t)iterator, (byte[][])key);
                if (BYTE_ARRAY_COMPARATOR.compare(endKey, key[0]) < 1) {
                    return;
                }
                LevelDB.leveldb_delete((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_writeoptions_t)writeOptions, (byte[])key[0], (String[])error);
                LevelDBStorageSystemProvider.checkError(error);
                LevelDB.leveldb_iter_next((SWIGTYPE_p_leveldb_iterator_t)iterator);
            }
        }
        finally {
            LevelDB.leveldb_iter_destroy((SWIGTYPE_p_leveldb_iterator_t)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doScan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback, boolean includeValue) throws StorageException {
        this.throwIfShutdown();
        SWIGTYPE_p_leveldb_iterator_t iterator = LevelDB.leveldb_create_iterator((SWIGTYPE_p_leveldb_t)this.db, (SWIGTYPE_p_leveldb_readoptions_t)readOptions);
        try {
            LevelDB.leveldb_iter_seek((SWIGTYPE_p_leveldb_iterator_t)iterator, (byte[])beginKey);
            LevelDBStore.reportEntries(iterator, endKey, callback, includeValue);
        }
        finally {
            LevelDB.leveldb_iter_destroy((SWIGTYPE_p_leveldb_iterator_t)iterator);
        }
    }

    private static void reportEntries(SWIGTYPE_p_leveldb_iterator_t iterator, byte @Nullable [] endKey, IKeyValueCallback callback, boolean includeValue) {
        byte[][] key = new byte[][]{null};
        byte[][] value = new byte[][]{null};
        while (LevelDB.leveldb_iter_valid((SWIGTYPE_p_leveldb_iterator_t)iterator) != 0) {
            LevelDB.leveldb_iter_key2((SWIGTYPE_p_leveldb_iterator_t)iterator, (byte[][])key);
            if (endKey != null && BYTE_ARRAY_COMPARATOR.compare(endKey, key[0]) < 1) {
                return;
            }
            if (includeValue) {
                LevelDB.leveldb_iter_value2((SWIGTYPE_p_leveldb_iterator_t)iterator, (byte[][])value);
            }
            callback.callback(key[0], value[0]);
            LevelDB.leveldb_iter_next((SWIGTYPE_p_leveldb_iterator_t)iterator);
        }
    }

    static {
        BYTE_ARRAY_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    }
}

