/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAssignmentPatternElementTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LexicalVariablesTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class ReadWriteUsages {
    private final SymbolTable symbolTable;
    private final Set<SyntaxToken> writes = new HashSet<SyntaxToken>();
    private final Set<SyntaxToken> readAssignment = new HashSet<SyntaxToken>();
    private final Set<SyntaxToken> declarations = new HashSet<SyntaxToken>();
    private final Map<Symbol, List<Symbol>> inheritedVariablesByParent = new HashMap<Symbol, List<Symbol>>();
    private final Map<Symbol, Symbol> parentSymbolByInheritedReference = new HashMap<Symbol, Symbol>();

    public ReadWriteUsages(Tree tree, SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        tree.accept(new UsageVisitor());
    }

    public boolean isRead(Symbol symbol) {
        return this.hasReadUsage(symbol) || this.inheritedVariablesByParent.getOrDefault(symbol, Collections.emptyList()).stream().anyMatch(this::isRead) || this.hasParentWhichIsRead(symbol);
    }

    public List<SyntaxToken> getWritesSorted(Symbol symbol) {
        ArrayList<SyntaxToken> allReferences = new ArrayList<SyntaxToken>(symbol.usages());
        allReferences.add(symbol.declaration().token());
        return allReferences.stream().filter(this.writes::contains).sorted(Comparator.comparing(SyntaxToken::line).reversed()).toList();
    }

    private boolean hasReadUsage(Symbol symbol) {
        ArrayList<SyntaxToken> allReferences = new ArrayList<SyntaxToken>();
        allReferences.add(symbol.declaration().token());
        allReferences.addAll(symbol.usages());
        return allReferences.stream().anyMatch(t -> !this.writes.contains(t) && !this.declarations.contains(t) || this.readAssignment.contains(t));
    }

    private boolean hasParentWhichIsRead(Symbol symbol) {
        Symbol parent = this.parentSymbolByInheritedReference.get(symbol);
        return parent != null && this.hasReadUsage(parent);
    }

    private class UsageVisitor
    extends PHPVisitorCheck {
        private UsageVisitor() {
        }

        @Override
        public void visitVariableDeclaration(VariableDeclarationTree tree) {
            this.visitAssignedVariable(tree.identifier());
            super.visitVariableDeclaration(tree);
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!tree.getParent().is(Tree.Kind.EXPRESSION_STATEMENT) && !tree.operator().startsWith("=")) {
                this.visitReadAssignedVariable(tree.variable());
            } else {
                this.visitAssignedVariable(tree.variable());
            }
            super.visitAssignmentExpression(tree);
        }

        @Override
        public void visitArrayAssignmentPatternElement(ArrayAssignmentPatternElementTree tree) {
            this.visitAssignedVariable(tree.variable());
            super.visitArrayAssignmentPatternElement(tree);
        }

        @Override
        public void visitForEachStatement(ForEachStatementTree tree) {
            ExpressionTree key = tree.key();
            if (key != null) {
                this.visitAssignedVariable(key);
            }
            this.visitAssignedVariable(tree.value());
            super.visitForEachStatement(tree);
        }

        private void visitAssignedVariable(Tree tree) {
            if (tree.is(Tree.Kind.ARRAY_ACCESS)) {
                this.visitReadAssignedVariable(((ArrayAccessTree)tree).object());
                return;
            }
            if (!tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                return;
            }
            ReadWriteUsages.this.writes.add(((VariableIdentifierTree)tree).token());
        }

        private void visitReadAssignedVariable(Tree tree) {
            if (tree.is(Tree.Kind.ARRAY_ACCESS)) {
                this.visitReadAssignedVariable(((ArrayAccessTree)tree).object());
                return;
            }
            if (!tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                return;
            }
            SyntaxToken token = ((VariableIdentifierTree)tree).token();
            ReadWriteUsages.this.writes.add(token);
            ReadWriteUsages.this.readAssignment.add(token);
        }

        @Override
        public void visitFunctionExpression(FunctionExpressionTree tree) {
            LexicalVariablesTree lexicalVars = tree.lexicalVars();
            if (lexicalVars != null) {
                Scope scope = ReadWriteUsages.this.symbolTable.getScopeFor(tree);
                for (VariableTree variableTree : lexicalVars.variables()) {
                    this.visitLexicalVar(scope, variableTree);
                }
            }
            super.visitFunctionExpression(tree);
        }

        private void visitLexicalVar(Scope scope, VariableTree variableTree) {
            Scope parentScope = scope.outer();
            VariableIdentifierTree variableIdentifier = null;
            if (variableTree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                variableIdentifier = (VariableIdentifierTree)variableTree;
                Symbol parentScopeSymbol = parentScope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                Symbol symbol = scope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                if (parentScopeSymbol != null && symbol != null) {
                    ReadWriteUsages.this.inheritedVariablesByParent.computeIfAbsent(parentScopeSymbol, key -> new ArrayList()).add(symbol);
                }
            } else if (variableTree.is(Tree.Kind.REFERENCE_VARIABLE) && variableTree.variableExpression().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
                variableIdentifier = (VariableIdentifierTree)variableTree.variableExpression();
                Symbol parentScopeSymbol = parentScope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                Symbol symbol = scope.getSymbol(variableIdentifier.text(), new Symbol.Kind[0]);
                if (parentScopeSymbol != null && symbol != null) {
                    ReadWriteUsages.this.inheritedVariablesByParent.computeIfAbsent(parentScopeSymbol, key -> new ArrayList()).add(symbol);
                    ReadWriteUsages.this.parentSymbolByInheritedReference.put(symbol, parentScopeSymbol);
                }
            }
            if (variableIdentifier != null) {
                ReadWriteUsages.this.declarations.add(variableIdentifier.token());
            }
        }
    }
}

