/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.regex;

import java.util.ArrayList;
import java.util.Arrays;
import org.sonar.php.regex.PhpRegexUtils;
import org.sonar.php.symbols.LocationInFileImpl;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.LocationInFile;
import org.sonarsource.analyzer.commons.regex.ast.IndexRange;
import org.sonarsource.analyzer.commons.regex.php.PhpRegexSource;

public class PhpAnalyzerRegexSource
extends PhpRegexSource {
    private static final IndexRange OPENER_RANGE = new IndexRange(-1, 0);
    private final int sourceLine;
    private final int sourceStartOffset;
    private final int[] lineStartOffsets;

    public PhpAnalyzerRegexSource(LiteralTree stringLiteral) {
        this(PhpAnalyzerRegexSource.literalToString(stringLiteral), stringLiteral.value().charAt(0), stringLiteral.token());
    }

    private PhpAnalyzerRegexSource(String literalToString, char quote, SyntaxToken token) {
        super(PhpAnalyzerRegexSource.stripDelimiters(literalToString.trim()), quote);
        String leadingWhitespaces = PhpAnalyzerRegexSource.leadingWhitespaces(literalToString);
        int[] leadingWhitespaceLineStartOffsets = PhpAnalyzerRegexSource.lineStartOffsets(leadingWhitespaces);
        this.sourceLine = token.line() + leadingWhitespaceLineStartOffsets.length - 1;
        int delimiterOffset = leadingWhitespaces.length() - leadingWhitespaceLineStartOffsets[leadingWhitespaceLineStartOffsets.length - 1];
        this.sourceStartOffset = leadingWhitespaceLineStartOffsets.length == 1 ? token.column() + delimiterOffset + 1 + 1 : delimiterOffset + 1;
        this.lineStartOffsets = PhpAnalyzerRegexSource.lineStartOffsets(this.getSourceText());
    }

    private static String literalToString(LiteralTree literal) {
        if (literal.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            String literalValue = literal.value();
            return literalValue.substring(1, literalValue.length() - 1);
        }
        throw new IllegalArgumentException("Only string literals allowed");
    }

    private static String stripDelimiters(String pattern) {
        if (pattern.length() >= 2) {
            Character endDelimiter = PhpRegexUtils.getEndDelimiter(pattern);
            return pattern.substring(1, pattern.lastIndexOf(endDelimiter.charValue()));
        }
        throw new IllegalArgumentException("Regular expression does not contain delimiters");
    }

    private static String leadingWhitespaces(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(0, i);
    }

    public LocationInFile locationInFileFor(IndexRange range) {
        if (OPENER_RANGE.equals(range)) {
            return new LocationInFileImpl(null, this.sourceLine, this.sourceStartOffset - 2, this.sourceLine, this.sourceStartOffset - 1);
        }
        int[] startLineAndOffset = this.lineAndOffset(range.getBeginningOffset());
        int[] endLineAndOffset = this.lineAndOffset(range.getEndingOffset());
        return new LocationInFileImpl(null, startLineAndOffset[0], startLineAndOffset[1], endLineAndOffset[0], endLineAndOffset[1]);
    }

    private int[] lineAndOffset(int index) {
        int offset;
        int line;
        int searchResult = Arrays.binarySearch(this.lineStartOffsets, index);
        if (searchResult >= 0) {
            line = this.sourceLine + searchResult;
            offset = 0;
        } else {
            line = this.sourceLine - searchResult - 2;
            offset = index - this.lineStartOffsets[-searchResult - 2];
        }
        if (line == this.sourceLine) {
            offset += this.sourceStartOffset;
        }
        return new int[]{line, offset};
    }

    private static int[] lineStartOffsets(String text) {
        ArrayList<Integer> lineStartOffsets = new ArrayList<Integer>();
        lineStartOffsets.add(0);
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != '\n' && text.charAt(i) != '\r') continue;
            int nextLineStartOffset = i + 1;
            if (i < length - 1 && text.charAt(i) == '\r' && text.charAt(i + 1) == '\n') {
                nextLineStartOffset = i + 2;
                ++i;
            }
            lineStartOffsets.add(nextLineStartOffset);
        }
        return lineStartOffsets.stream().mapToInt(x -> x).toArray();
    }
}

