/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.microsoft.alm.client.utils.ArgumentUtility;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DemandDeserializer;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DemandEquals;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DemandExists;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DemandMinimumVersion;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.contracts.DemandSerializer;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsonDeserialize(using=DemandDeserializer.class)
@JsonSerialize(using=DemandSerializer.class)
public abstract class Demand {
    private final String name;
    private final String value;
    private static final Pattern DEMAND_PATTERN = Pattern.compile("^([^ ]+)([ ]+\\-([^ ]+)[ ]+(.*))?$");

    protected Demand(String name, String value) {
        ArgumentUtility.checkStringForNullOrEmpty(name, "name");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected abstract String getExpression();

    public boolean equals(Object obj) {
        if (obj instanceof Demand) {
            Demand demand = (Demand)obj;
            return demand != null && demand.toString().equalsIgnoreCase(this.toString());
        }
        return false;
    }

    public final int hashCode() {
        return this.toString().toUpperCase(Locale.ROOT).hashCode();
    }

    public final String toString() {
        return this.getExpression();
    }

    public static Demand tryParse(String input) {
        Demand demand = null;
        Matcher match = DEMAND_PATTERN.matcher(input);
        if (!match.matches()) {
            return null;
        }
        String name = match.group(1);
        String opcode = match.group(3);
        String value = match.group(4);
        if (StringUtil.isNullOrEmpty(opcode)) {
            demand = new DemandExists(name);
        } else if (opcode.equals("equals")) {
            demand = new DemandEquals(name, value);
        } else if (opcode.equals("gtVersion")) {
            demand = new DemandMinimumVersion(name, value);
        }
        return demand;
    }
}

