/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.InvalidPendingChangeTableException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayerLocalWorkspaces;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.NotYetImplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LocalPendingChangesTableHeader
extends LocalMetadataTable {
    private static final short MAGIC = 29733;
    private static final byte SCHEMA_VERSION_1 = 1;
    private static final byte SCHEMA_VERSION_2 = 2;
    private int pendingChangeCount;
    private GUID clientSignature;

    public LocalPendingChangesTableHeader(String fileName, LocalMetadataTable cachedLoadSource) throws Exception {
        super(fileName, cachedLoadSource);
    }

    @Override
    protected void initialize() {
        this.clientSignature = WebServiceLayerLocalWorkspaces.INITIAL_PENDING_CHANGES_SIGNATURE;
        this.pendingChangeCount = 0;
    }

    @Override
    protected void load(InputStream is) throws InvalidPendingChangeTableException, IOException {
        block8: {
            BinaryReader br = new BinaryReader(is, "UTF-16LE");
            try {
                short magic = br.readInt16();
                if (29733 != magic) {
                    throw new InvalidPendingChangeTableException();
                }
                byte schemaVersion = br.readByte();
                if (schemaVersion == 1 || schemaVersion == 2) {
                    this.loadFromVersion1(br);
                    break block8;
                }
                throw new InvalidPendingChangeTableException();
            }
            catch (Exception e) {
                if (e instanceof InvalidPendingChangeTableException) {
                    throw (InvalidPendingChangeTableException)e;
                }
                throw new InvalidPendingChangeTableException(e);
            }
            finally {
                br.close();
            }
        }
    }

    private void loadFromVersion1(BinaryReader br) throws IOException {
        byte[] clientSignatureBytes = br.readBytes(16);
        this.clientSignature = new GUID(clientSignatureBytes);
        this.pendingChangeCount = br.readInt32();
    }

    @Override
    protected boolean cachedLoad(LocalMetadataTable source) {
        if (source instanceof LocalPendingChangesTable) {
            LocalPendingChangesTable pcCached = (LocalPendingChangesTable)source;
            this.clientSignature = pcCached.getClientSignature();
            this.pendingChangeCount = pcCached.getCount();
            return true;
        }
        if (source instanceof LocalPendingChangesTableHeader) {
            LocalPendingChangesTableHeader pchCached = (LocalPendingChangesTableHeader)source;
            this.clientSignature = pchCached.clientSignature;
            this.pendingChangeCount = pchCached.pendingChangeCount;
            return true;
        }
        return false;
    }

    @Override
    protected boolean save(OutputStream os) {
        throw new NotYetImplementedException();
    }

    public GUID getClientSignature() {
        return this.clientSignature;
    }

    public int getCount() {
        return this.pendingChangeCount;
    }
}

