/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.ProcessType;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryWriter;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItemStates;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.ServerItemLocalVersionUpdate;
import com.microsoft.tfs.util.Platform;
import java.io.IOException;
import java.util.Arrays;

public class WorkspaceLocalItem {
    private static final byte[] EMPTY_HASH = new byte[16];
    private static final byte[] ZERO_LENGTH_ARRAY_BYTES = new byte[0];
    private byte flags;
    private String serverItem;
    private String localItem;
    private int version;
    private int itemID;
    private long lastModifiedTime = -1L;
    private int encoding;
    private long checkinDate = -1L;
    private long length;
    private byte[] hashValue = ZERO_LENGTH_ARRAY_BYTES;
    private byte[] baselineFileGUID;

    public void saveToVersion2(BinaryWriter writer) throws IOException {
        writer.write(this.flags);
        writer.write(this.serverItem);
        writer.write(this.localItem == null ? "" : this.localItem);
        writer.write(this.version);
        writer.write(this.itemID);
        writer.write(this.lastModifiedTime);
        writer.write(this.encoding);
        writer.write(this.checkinDate);
        if (!this.isDirectory()) {
            writer.write(this.length);
            if (null == this.hashValue || this.hashValue.length != 16) {
                writer.write(EMPTY_HASH);
            } else {
                writer.write(this.hashValue);
            }
            if (this.baselineFileGUID == null || this.baselineFileGUID.length != 16) {
                writer.write(false);
            } else {
                writer.write(true);
                writer.write(this.baselineFileGUID);
            }
        }
    }

    public static WorkspaceLocalItem fromVersion1(BinaryReader reader) throws IOException {
        WorkspaceLocalItem toReturn = new WorkspaceLocalItem();
        toReturn.flags = reader.readByte();
        toReturn.serverItem = reader.readString();
        toReturn.localItem = reader.readString();
        toReturn.version = reader.readInt32();
        toReturn.itemID = reader.readInt32();
        toReturn.lastModifiedTime = reader.readInt64();
        toReturn.encoding = reader.readInt32();
        if (toReturn.localItem == null || toReturn.localItem.length() == 0) {
            toReturn.localItem = null;
        }
        if (!toReturn.isDirectory()) {
            toReturn.length = reader.readInt64();
            toReturn.hashValue = reader.readBytes(16);
            if (Arrays.equals(toReturn.hashValue, EMPTY_HASH)) {
                toReturn.hashValue = ZERO_LENGTH_ARRAY_BYTES;
            }
            if (reader.readBoolean()) {
                toReturn.baselineFileGUID = reader.readBytes(16);
            }
        } else {
            toReturn.length = 0L;
            toReturn.hashValue = ZERO_LENGTH_ARRAY_BYTES;
        }
        return toReturn;
    }

    public static WorkspaceLocalItem fromVersion2(BinaryReader reader) throws IOException {
        WorkspaceLocalItem toReturn = new WorkspaceLocalItem();
        toReturn.flags = reader.readByte();
        toReturn.serverItem = reader.readString();
        toReturn.localItem = reader.readString();
        toReturn.version = reader.readInt32();
        toReturn.itemID = reader.readInt32();
        toReturn.lastModifiedTime = reader.readInt64();
        toReturn.encoding = reader.readInt32();
        toReturn.checkinDate = reader.readInt64();
        if (toReturn.localItem == null || toReturn.localItem.length() == 0) {
            toReturn.localItem = null;
        }
        if (!toReturn.isDirectory()) {
            toReturn.length = reader.readInt64();
            toReturn.hashValue = reader.readBytes(16);
            if (Arrays.equals(toReturn.hashValue, EMPTY_HASH)) {
                toReturn.hashValue = ZERO_LENGTH_ARRAY_BYTES;
            }
            if (reader.readBoolean()) {
                toReturn.baselineFileGUID = reader.readBytes(16);
            }
        } else {
            toReturn.length = 0L;
            toReturn.hashValue = ZERO_LENGTH_ARRAY_BYTES;
        }
        return toReturn;
    }

    public boolean isDirectory() {
        return -3 == this.encoding;
    }

    public ItemType getItemType() {
        if (-3 == this.encoding) {
            return ItemType.FOLDER;
        }
        return ItemType.FILE;
    }

    public boolean isCommitted() {
        return this.version != 0;
    }

    public boolean isPendingReconcile() {
        return (this.flags & (byte)WorkspaceLocalItemStates.PENDING_RECONCILE.toIntFlags()) != 0;
    }

    public void setPendingReconcile(boolean value) {
        this.flags = value ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.PENDING_RECONCILE.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.PENDING_RECONCILE.toIntFlags()));
    }

    public boolean isMissingOnDisk() {
        return (this.flags & (byte)WorkspaceLocalItemStates.LOCAL_ITEM_MISSING.toIntFlags()) != 0;
    }

    public void setMissingOnDisk(boolean value) {
        this.flags = value ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.LOCAL_ITEM_MISSING.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.LOCAL_ITEM_MISSING.toIntFlags()));
    }

    public boolean isDeleted() {
        return (this.flags & (byte)WorkspaceLocalItemStates.DELETED.toIntFlags()) != 0;
    }

    public void setDeleted(boolean value) {
        this.flags = value ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.DELETED.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.DELETED.toIntFlags()));
    }

    public boolean isScanned() {
        return (this.flags & (byte)WorkspaceLocalItemStates.SCANNED.toIntFlags()) != 0;
    }

    public void setScanned(boolean value) {
        this.flags = value ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.SCANNED.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.SCANNED.toIntFlags()));
    }

    public PropertyValue[] getPropertyValues() {
        boolean executableFlag = (this.flags & (byte)WorkspaceLocalItemStates.EXECUTABLE.toIntFlags()) != 0;
        boolean symlinkFlag = (this.flags & (byte)WorkspaceLocalItemStates.SYMLINK.toIntFlags()) != 0;
        PropertyValue[] values = new PropertyValue[]{symlinkFlag ? PropertyConstants.IS_SYMLINK : (executableFlag ? PropertyConstants.EXECUTABLE_ENABLED_VALUE : PropertyConstants.EXECUTABLE_DISABLED_VALUE)};
        return values;
    }

    public void setPropertyValues(PropertyValue[] values) {
        PropertyValue v = PropertyUtils.selectMatching(values, "Microsoft.TeamFoundation.VersionControl.SymbolicLink");
        PropertyValue x = PropertyUtils.selectMatching(values, "Microsoft.TeamFoundation.VersionControl.Executable");
        this.flags = PropertyConstants.IS_SYMLINK.equals(v) ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.SYMLINK.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.SYMLINK.toIntFlags()));
        this.flags = PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(x) ? (byte)(this.flags | (byte)WorkspaceLocalItemStates.EXECUTABLE.toIntFlags()) : (byte)(this.flags & (byte)(~WorkspaceLocalItemStates.EXECUTABLE.toIntFlags()));
    }

    public boolean hasHashValue() {
        return null != this.hashValue && 16 == this.hashValue.length;
    }

    public boolean hasBaselineFileGUID() {
        return null != this.baselineFileGUID && 16 == this.baselineFileGUID.length;
    }

    public WorkspaceLocalItem clone() {
        WorkspaceLocalItem clone = new WorkspaceLocalItem();
        clone.version = this.version;
        clone.flags = this.flags;
        clone.serverItem = this.serverItem;
        clone.localItem = this.localItem;
        clone.length = this.length;
        clone.lastModifiedTime = this.lastModifiedTime;
        clone.itemID = this.itemID;
        clone.encoding = this.encoding;
        clone.checkinDate = this.checkinDate;
        clone.hashValue = null == this.hashValue || this.hashValue.length != 16 ? ZERO_LENGTH_ARRAY_BYTES : (byte[])this.hashValue.clone();
        if (null != this.baselineFileGUID) {
            clone.baselineFileGUID = (byte[])this.baselineFileGUID.clone();
        }
        return clone;
    }

    public ServerItemLocalVersionUpdate getLocalVersionUpdate() {
        return this.getLocalVersionUpdate(false, false);
    }

    public ServerItemLocalVersionUpdate getLocalVersionUpdate(boolean reconcileMissingOnDisk) {
        return this.getLocalVersionUpdate(reconcileMissingOnDisk, false);
    }

    public ServerItemLocalVersionUpdate getLocalVersionUpdate(boolean reconcileMissingOnDisk, boolean force) {
        if (!(this.isPendingReconcile() || reconcileMissingOnDisk && this.isMissingOnDisk() || force)) {
            return null;
        }
        ServerItemLocalVersionUpdate toReturn = new ServerItemLocalVersionUpdate();
        toReturn.setSourceServerItem(this.serverItem);
        toReturn.setLocalVersion(this.version);
        toReturn.setTargetLocalItem(this.localItem);
        if (this.isDeleted() || reconcileMissingOnDisk && this.isMissingOnDisk()) {
            toReturn.setTargetLocalItem(null);
        }
        return toReturn;
    }

    public GetOperation toGetOperation(String[] itemPropertyFilters) {
        GetOperation getOp = new GetOperation();
        getOp.setItemType(this.isDirectory() ? ItemType.FOLDER : ItemType.FILE);
        getOp.setVersionLocal(this.getVersion());
        getOp.setVersionServer(this.getVersion());
        getOp.setDeletionID(0);
        getOp.setSourceLocalItem(this.getLocalItem());
        getOp.setTargetLocalItem(this.getLocalItem());
        getOp.setTargetServerItem(this.getServerItem());
        getOp.setItemID(this.getItemID());
        getOp.setHashValue((byte[])this.getHashValue().clone());
        getOp.setEncoding(this.getEncoding());
        getOp.setSourceServerItem(this.getServerItem());
        getOp.setLocalVersionEntry(this);
        getOp.setPropertyValues(PropertyUtils.selectMatching(this.getPropertyValues(), itemPropertyFilters));
        return getOp;
    }

    public GetOperation toGetOperation(LocalPendingChange pcEntry, String[] itemPropertyFilters) {
        GetOperation getOp = this.toGetOperation(itemPropertyFilters);
        getOp.setTargetServerItem(pcEntry.getTargetServerItem());
        if (!pcEntry.isCommitted()) {
            getOp.setSourceServerItem(pcEntry.getTargetServerItem());
        }
        getOp.setBaselineFileGUID(this.getBaselineFileGUID());
        getOp.setPendingChangeID(-123);
        getOp.setChangeType(pcEntry.getChangeType());
        getOp.setLockLevel(LockLevel.fromByteValue(pcEntry.getLockStatus()));
        getOp.setHasConflict(false);
        getOp.setHashValue(pcEntry.getHashValue());
        getOp.setProcessType(ProcessType.PEND);
        getOp.setPropertyValues(pcEntry.getPropertyValues());
        return getOp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        sb.append("WorkspaceLocalItem instance " + this.hashCode()).append(newline);
        sb.append("  ServerItem: " + this.serverItem).append(newline);
        sb.append("  LocalItem: " + this.localItem).append(newline);
        sb.append("  Version: " + this.version).append(newline);
        sb.append("  Flags: " + this.flags).append(newline);
        sb.append("  Length: " + this.length).append(newline);
        sb.append("  HashValue: " + Arrays.toString(this.hashValue)).append(newline);
        sb.append("  LastModifiedTime: " + this.lastModifiedTime).append(newline);
        sb.append("  ItemId: " + this.itemID).append(newline);
        sb.append("  Encoding: " + this.encoding).append(newline);
        sb.append("  CheckinDate: " + this.checkinDate).append(newline);
        sb.append("  BaselineFileGuid: " + Arrays.toString(this.baselineFileGUID)).append(newline);
        return sb.toString();
    }

    public long getCheckinDate() {
        return this.checkinDate;
    }

    public void setCheckinDate(long value) {
        this.checkinDate = value;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public void setEncoding(int value) {
        this.encoding = value;
    }

    public int getItemID() {
        return this.itemID;
    }

    public void setItemID(int value) {
        this.itemID = value;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(long value) {
        this.lastModifiedTime = value;
    }

    public long getLength() {
        if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX) && this.isSymbolicLink()) {
            return 0L;
        }
        return this.length;
    }

    public void setLength(long value) {
        this.length = value;
    }

    public String getLocalItem() {
        return this.localItem;
    }

    public void setLocalItem(String value) {
        this.localItem = value;
    }

    public String getServerItem() {
        return this.serverItem;
    }

    public void setServerItem(String value) {
        this.serverItem = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int value) {
        this.version = value;
    }

    public byte[] getBaselineFileGUID() {
        return this.baselineFileGUID;
    }

    public void setBaselineFileGUID(byte[] value) {
        this.baselineFileGUID = value;
    }

    public byte[] getHashValue() {
        return this.hashValue != null ? (byte[])this.hashValue.clone() : null;
    }

    public void setHashValue(byte[] hashValue) {
        this.hashValue = hashValue != null ? (byte[])hashValue.clone() : null;
    }

    public boolean isSymbolicLink() {
        return (this.flags & (byte)WorkspaceLocalItemStates.SYMLINK.toIntFlags()) != 0;
    }
}

