/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyConstants;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.util.BitField;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import ms.tfs.versioncontrol.clientservices._03._ChangeType;

public final class ChangeType
extends BitField {
    public static final ChangeType NONE = new ChangeType(0, _ChangeType._ChangeType_Flag.None.toString(), false);
    public static final ChangeType ADD = new ChangeType(2, _ChangeType._ChangeType_Flag.Add.toString(), false);
    public static final ChangeType EDIT = new ChangeType(4, _ChangeType._ChangeType_Flag.Edit.toString(), false);
    public static final ChangeType ENCODING = new ChangeType(8, _ChangeType._ChangeType_Flag.Encoding.toString(), false);
    public static final ChangeType RENAME = new ChangeType(16, _ChangeType._ChangeType_Flag.Rename.toString(), false);
    public static final ChangeType DELETE = new ChangeType(32, _ChangeType._ChangeType_Flag.Delete.toString(), false);
    public static final ChangeType UNDELETE = new ChangeType(64, _ChangeType._ChangeType_Flag.Undelete.toString(), false);
    public static final ChangeType BRANCH = new ChangeType(128, _ChangeType._ChangeType_Flag.Branch.toString(), false);
    public static final ChangeType MERGE = new ChangeType(256, _ChangeType._ChangeType_Flag.Merge.toString(), false);
    public static final ChangeType LOCK = new ChangeType(512, _ChangeType._ChangeType_Flag.Lock.toString(), false);
    public static final ChangeType ROLLBACK = new ChangeType(1024, _ChangeType._ChangeType_Flag.Rollback.toString(), true);
    public static final ChangeType SOURCE_RENAME = new ChangeType(2048, _ChangeType._ChangeType_Flag.SourceRename.toString(), true);
    public static final ChangeType TARGET_RENAME = new ChangeType(4096, "TargetRename", true);
    public static final ChangeType PROPERTY = new ChangeType(8192, _ChangeType._ChangeType_Flag.Property.toString(), true);
    public static final ChangeType ALL = new ChangeType(65535, "ALL", false);
    public static final ChangeType ADD_ENCODING = ADD.combine(ENCODING);
    public static final ChangeType ADD_EDIT_ENCODING = ADD.combine(EDIT).combine(ENCODING);
    public static final ChangeType RENAME_OR_DELETE = RENAME.combine(DELETE);
    public static final ChangeType ADD_BRANCH_OR_RENAME = ADD.combine(BRANCH).combine(RENAME);

    private ChangeType(int flags, String name, boolean forceSpecial) {
        super(flags);
        ChangeType.registerStringValue(this.getClass(), flags, name, forceSpecial);
    }

    private ChangeType(int flags) {
        super(flags);
    }

    public ChangeType(_ChangeType flagSet, int flagsExtended) {
        this(ChangeType.webServiceObjectToFlags(flagSet) | flagsExtended << 1);
    }

    private static int webServiceObjectToFlags(_ChangeType webServiceObject) {
        Check.notNull(webServiceObject, "changeType");
        ArrayList<String> strings = new ArrayList<String>();
        _ChangeType._ChangeType_Flag[] flags = webServiceObject.getFlags();
        for (int i = 0; i < flags.length; ++i) {
            strings.add(flags[i].toString());
        }
        return ChangeType.fromStringValues(strings.toArray(new String[strings.size()]), ChangeType.class);
    }

    public _ChangeType getWebServiceObject() {
        return new _ChangeType(this.toStringValues());
    }

    public int getWebServiceObjectExtendedFlags() {
        return this.toIntFlags() >> 1;
    }

    public static ChangeType combine(ChangeType[] changeTypes) {
        return new ChangeType(BitField.combine(changeTypes));
    }

    public boolean containsAll(ChangeType other) {
        return this.containsAllInternal(other);
    }

    public boolean contains(ChangeType other) {
        return this.containsInternal(other);
    }

    public boolean containsAny(ChangeType other) {
        return this.containsAnyInternal(other);
    }

    public ChangeType remove(ChangeType other) {
        return new ChangeType(this.removeInternal(other));
    }

    public ChangeType retain(ChangeType other) {
        return new ChangeType(this.retainInternal(other));
    }

    public ChangeType combine(ChangeType other) {
        return new ChangeType(this.combineInternal(other));
    }

    public String toUIString(boolean showLock) {
        return this.toUIString(showLock, (PropertyValue[])null);
    }

    public String toUIString(boolean showLock, Item item) {
        return this.toUIString(showLock, item != null ? item.getPropertyValues() : null);
    }

    public String toUIString(boolean showLock, ExtendedItem extendedItem) {
        return this.toUIString(showLock, extendedItem != null ? extendedItem.getPropertyValues() : null);
    }

    public String toUIString(boolean showLock, PendingChange pendingChange) {
        return this.toUIString(showLock, pendingChange != null ? pendingChange.getPropertyValues() : null);
    }

    public String toUIString(boolean showLock, Change change) {
        Item item = change != null ? change.getItem() : null;
        return this.toUIString(showLock, item != null ? item.getPropertyValues() : null);
    }

    public String toUIString(boolean showLock, PropertyValue[] properties) {
        ChangeType tmpChangeType = new ChangeType(this.toIntFlags());
        StringBuilder sb = new StringBuilder();
        if (!showLock && !tmpChangeType.equals(LOCK)) {
            tmpChangeType.remove(LOCK);
        }
        ChangeType.appendIf(tmpChangeType.contains(MERGE), sb, "ChangeType.MergeDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(ADD), sb, "ChangeType.AddDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(BRANCH), sb, "ChangeType.BranchDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(DELETE), sb, "ChangeType.DeleteDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(ENCODING) && !tmpChangeType.contains(BRANCH) && !tmpChangeType.contains(ADD), sb, "ChangeType.EncodingDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(LOCK), sb, "ChangeType.LockDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(RENAME), sb, "ChangeType.RenameDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(UNDELETE), sb, "ChangeType.UndeleteDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(EDIT) && !tmpChangeType.contains(ADD), sb, "ChangeType.EditDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(ROLLBACK), sb, "ChangeType.RollbackDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(SOURCE_RENAME), sb, "ChangeType.SourceRenameDYNAMIC");
        ChangeType.appendIf(tmpChangeType.contains(PROPERTY), sb, "ChangeType.PropertyDYNAMIC");
        if (tmpChangeType.contains(PROPERTY)) {
            StringBuilder propertiesSummary = new StringBuilder();
            PropertyValue symlink = PropertyUtils.selectMatching(properties, "Microsoft.TeamFoundation.VersionControl.SymbolicLink");
            PropertyValue executable = PropertyUtils.selectMatching(properties, "Microsoft.TeamFoundation.VersionControl.Executable");
            if (symlink != null) {
                if (PropertyConstants.IS_SYMLINK.equals(symlink)) {
                    propertiesSummary.append(Messages.getString("ChangeType.ChangeToSymlinkSummary"));
                } else if (PropertyConstants.NOT_SYMLINK.equals(symlink)) {
                    propertiesSummary.append(Messages.getString("ChangeType.LoseSymlinkSummary"));
                }
            }
            if (executable != null) {
                if (PropertyConstants.EXECUTABLE_ENABLED_VALUE.equals(executable)) {
                    propertiesSummary.append(Messages.getString("ChangeType.EnableExecutableSummary"));
                } else if (PropertyConstants.EXECUTABLE_DISABLED_VALUE.equals(executable)) {
                    propertiesSummary.append(Messages.getString("ChangeType.DisableExecutableSummary"));
                }
            }
            if (propertiesSummary.length() > 0) {
                sb.append(MessageFormat.format(Messages.getString("ChangeType.PropertiesSummaryListFormat"), propertiesSummary.toString()));
            }
        }
        return sb.toString();
    }

    private static void appendIf(boolean condition, StringBuilder sb, String messageKey) {
        if (condition) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(Messages.getString(messageKey));
        }
    }

    public static ChangeType fromIntFlags(int flags) {
        return new ChangeType(flags);
    }

    public static ChangeType fromIntFlags(int flags, int extendedFlags) {
        return new ChangeType(flags | extendedFlags << 1);
    }
}

