/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import ms.tfs.versioncontrol.clientservices._03._GetRequest;

public final class GetRequest
extends WebServiceObjectWrapper {
    public GetRequest(ItemSpec itemSpec, VersionSpec versionSpec) {
        super(new _GetRequest(itemSpec != null ? itemSpec.getWebServiceObject() : null, versionSpec.getWebServiceObject()));
    }

    public _GetRequest getWebServiceObject() {
        return (_GetRequest)this.webServiceObject;
    }

    public ItemSpec getItemSpec() {
        if (this.getWebServiceObject().getItemSpec() == null) {
            return null;
        }
        return new ItemSpec(this.getWebServiceObject().getItemSpec());
    }

    public void setItemSpec(ItemSpec itemSpec) {
        Check.notNull(itemSpec, "itemSpec");
        this.getWebServiceObject().setItemSpec(itemSpec.getWebServiceObject());
    }

    public VersionSpec getVersionSpec() {
        return VersionSpec.fromWebServiceObject(this.getWebServiceObject().getVersionSpec());
    }

    public void setVersionSpec(VersionSpec versionSpec) {
        Check.notNull(versionSpec, "versionSpec");
        this.getWebServiceObject().setVersionSpec(versionSpec.getWebServiceObject());
    }

    @Override
    public String toString() {
        _GetRequest request = this.getWebServiceObject();
        String item = request.getItemSpec() != null ? request.getItemSpec().getItem() : "<null>";
        String recursionType = request.getItemSpec() != null && request.getItemSpec().getRecurse() != null ? request.getItemSpec().getRecurse().getName() : "null";
        return MessageFormat.format("{0}: {1}", item, recursionType);
    }

    public static GetRequest[] createOptimizedRequests(VersionControlClient client, String[] fileSpecs, VersionSpec version) {
        Check.notNull(client, "client");
        Check.notNull(fileSpecs, "fileSpecs");
        Check.notNull(version, "version");
        ArrayList<GetRequest> retval = new ArrayList<GetRequest>(fileSpecs.length);
        if (fileSpecs.length > 0) {
            String[] localFilePaths = new String[fileSpecs.length];
            System.arraycopy(fileSpecs, 0, localFilePaths, 0, fileSpecs.length);
            Arrays.sort(localFilePaths, LocalPath.TOP_DOWN_COMPARATOR);
            String currentParent = null;
            int folderDepthOfLastItem = -1;
            GetRequest lastRequestAdded = null;
            for (String filepath : localFilePaths) {
                int folderDepth = LocalPath.getFolderDepth(filepath);
                if (currentParent == null || !LocalPath.isChild(currentParent, filepath)) {
                    GetRequest request;
                    currentParent = LocalPath.getParent(filepath);
                    if (currentParent != null && Workstation.getCurrent(client.getConnection().getPersistenceStoreProvider()).isMapped(currentParent)) {
                        request = new GetRequest(new ItemSpec(currentParent, RecursionType.ONE_LEVEL), version);
                    } else {
                        request = new GetRequest(new ItemSpec(filepath, RecursionType.NONE), version);
                        currentParent = null;
                    }
                    lastRequestAdded = request;
                    retval.add(request);
                } else if (folderDepth != folderDepthOfLastItem) {
                    lastRequestAdded.getItemSpec().setRecursionType(RecursionType.FULL);
                }
                folderDepthOfLastItem = folderDepth;
            }
        }
        return retval.toArray(new GetRequest[retval.size()]);
    }
}

