/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.checkinpolicies.PolicyFailure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PolicyFailureInfo;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import ms.tfs.versioncontrol.clientservices._03._PolicyFailureInfo;
import ms.tfs.versioncontrol.clientservices._03._PolicyOverrideInfo;

public final class PolicyOverrideInfo
extends WebServiceObjectWrapper {
    public PolicyOverrideInfo() {
        super(new _PolicyOverrideInfo());
    }

    public PolicyOverrideInfo(_PolicyOverrideInfo info) {
        super(info);
    }

    public PolicyOverrideInfo(String comment, PolicyFailureInfo[] failureInfos) {
        super(new _PolicyOverrideInfo(comment, PolicyOverrideInfo.getWebServiceObjectInfoArray(failureInfos)));
    }

    public PolicyOverrideInfo(String comment, PolicyFailure[] failures) {
        super(new _PolicyOverrideInfo(comment, PolicyOverrideInfo.getWebServiceObjectFailureArray(failures)));
    }

    private static _PolicyFailureInfo[] getWebServiceObjectInfoArray(PolicyFailureInfo[] infos) {
        Check.notNull(infos, "infos");
        return (_PolicyFailureInfo[])WrapperUtils.unwrap(_PolicyFailureInfo.class, infos);
    }

    private static _PolicyFailureInfo[] getWebServiceObjectFailureArray(PolicyFailure[] failures) {
        Check.notNull(failures, "infos");
        _PolicyFailureInfo[] ret = new _PolicyFailureInfo[failures.length];
        for (int i = 0; i < failures.length; ++i) {
            PolicyFailure failure = failures[i];
            String policyName = failure.getPolicy() != null ? failure.getPolicy().getPolicyType().getName() : "[" + Messages.getString("PolicyOverrideInfo.InvalidPolicy") + "]";
            ret[i] = new _PolicyFailureInfo(policyName, failure.getMessage());
        }
        return ret;
    }

    public _PolicyOverrideInfo getWebServiceObject() {
        return (_PolicyOverrideInfo)this.webServiceObject;
    }

    public String getComment() {
        return this.getWebServiceObject().getComment();
    }

    public PolicyFailureInfo[] getPolicyFailures() {
        Object[] internalFailures = this.getWebServiceObject().getPolicyFailures();
        if (internalFailures == null) {
            return new PolicyFailureInfo[0];
        }
        return (PolicyFailureInfo[])WrapperUtils.wrap(PolicyFailureInfo.class, internalFailures);
    }
}

