/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.specs.version;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelSpecParseException;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpecParseException;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DateVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.DeletionVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LabelVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpecParseException;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import ms.tfs.versioncontrol.clientservices._03._ChangesetVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._DateVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._LabelVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._LatestVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._VersionSpec;
import ms.tfs.versioncontrol.clientservices._03._WorkspaceVersionSpec;

public abstract class VersionSpec
extends WebServiceObjectWrapper {
    public static final char RANGE_DELIMITER = '~';

    protected VersionSpec(Object webServiceObject) {
        super(webServiceObject);
    }

    public static VersionSpec[] parseMultipleVersionsFromSpec(String versionSpecs, String user, boolean allowVersionRange) throws VersionSpecParseException, LabelSpecParseException {
        ArrayList<VersionSpec> versions = new ArrayList<VersionSpec>();
        Check.notNullOrEmpty(versionSpecs, "versionSpecs");
        String[] specs = versionSpecs.split(Character.toString('~'));
        if (!allowVersionRange && specs.length > 1) {
            throw new VersionSpecParseException(Messages.getString("VersionSpec.AVersionRangeIsNotAllowedInThisVersionSpec"));
        }
        for (int i = 0; i < specs.length; ++i) {
            VersionSpec vs = VersionSpec.parseSingleVersionFromSpec(specs[i], user);
            Check.notNull(vs, "vs");
            versions.add(vs);
        }
        return versions.toArray(new VersionSpec[0]);
    }

    public static VersionSpec parseSingleVersionFromSpec(String spec, String user) throws VersionSpecParseException, LabelSpecParseException {
        VersionSpec ret = null;
        if (spec == null || spec.length() == 0) {
            throw new VersionSpecParseException(Messages.getString("VersionSpec.TheVersionSpecStringMustNotBeNullOrEmpty"));
        }
        if (spec.indexOf(126) != -1) {
            throw new VersionSpecParseException(MessageFormat.format(Messages.getString("VersionSpec.TheVersionSpecStringMustNotContainRangeDelimiterCharacterFormat"), Character.valueOf('~')));
        }
        char specTypeChar = Character.toUpperCase(spec.charAt(0));
        if (specTypeChar == 'T') {
            if (spec.length() > 1) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheLatestVersionSpecMustContainOneCharacter"));
            }
            ret = LatestVersionSpec.INSTANCE;
        } else if (specTypeChar == 'X') {
            if (spec.length() == 1) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheDeletionIDSpecMustIncludeANumber"));
            }
            int deletionID = 0;
            try {
                deletionID = Integer.parseInt(spec.substring(1));
            }
            catch (NumberFormatException e) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheDeletionIDSpecWasNotRecognizedAsANumber"));
            }
            ret = new DeletionVersionSpec(deletionID);
        } else if (specTypeChar == 'W') {
            WorkspaceSpec ws;
            if (spec.length() == 1) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheWorkspaceSpecMustIncludeTheWorkspaceName"));
            }
            try {
                ws = WorkspaceSpec.parse(spec.substring(1), user);
            }
            catch (WorkspaceSpecParseException e) {
                throw new VersionSpecParseException(e.getMessage());
            }
            ret = new WorkspaceVersionSpec(ws);
        } else if (specTypeChar == 'L') {
            if (spec.length() == 1) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheLabelVersionSpecMustContainALabelNameAndScope"));
            }
            ret = new LabelVersionSpec(LabelSpec.parse(spec.substring(1), null, false));
        } else {
            if (specTypeChar == 'D') {
                if (spec.length() == 1) {
                    throw new VersionSpecParseException(Messages.getString("VersionSpec.TheDateVersionSpecMustContainADate"));
                }
                try {
                    DateVersionSpec dvs = new DateVersionSpec(spec.substring(1));
                    ret = dvs;
                }
                catch (ParseException e) {
                    throw new VersionSpecParseException(MessageFormat.format(Messages.getString("VersionSpec.TheValueCouldNotBeConvertedToADateFormat"), e.getMessage()));
                }
            }
            int changeSetNumber = 0;
            int index = 0;
            if (specTypeChar == 'C') {
                if (spec.length() == 1) {
                    throw new VersionSpecParseException(Messages.getString("VersionSpec.TheVersionSpecMustIncludeAChangesetNumber"));
                }
                index = 1;
            }
            try {
                changeSetNumber = Integer.parseInt(spec.substring(index));
            }
            catch (NumberFormatException e) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.TheChangesetVersionSpecWasNotRecognizedAsANumber"));
            }
            if (changeSetNumber < 1) {
                throw new VersionSpecParseException(Messages.getString("VersionSpec.AChangesetVersionNumberMustBePositiveInteger"));
            }
            ret = new ChangesetVersionSpec(changeSetNumber);
        }
        Check.notNull(ret, "ret");
        return ret;
    }

    public static final VersionSpec fromWebServiceObject(_VersionSpec spec) {
        if (spec instanceof _ChangesetVersionSpec) {
            return new ChangesetVersionSpec((_ChangesetVersionSpec)spec);
        }
        if (spec instanceof _LatestVersionSpec) {
            return LatestVersionSpec.INSTANCE;
        }
        if (spec instanceof _WorkspaceVersionSpec) {
            return new WorkspaceVersionSpec((_WorkspaceVersionSpec)spec);
        }
        if (spec instanceof _DateVersionSpec) {
            return new DateVersionSpec((_DateVersionSpec)spec);
        }
        if (spec instanceof _LabelVersionSpec) {
            return new LabelVersionSpec((_LabelVersionSpec)spec);
        }
        throw new RuntimeException(MessageFormat.format("Cannot convert {0} to any VersionSpec-derived class.", spec.getClass().getName().toString()));
    }

    public _VersionSpec getWebServiceObject() {
        return (_VersionSpec)this.webServiceObject;
    }

    @Override
    public abstract String toString();
}

