/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal;

import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemStateListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WorkItemStateListenerSupport {
    private final Set<WorkItemStateListener> listeners = new HashSet<WorkItemStateListener>();
    private final WorkItem workItem;

    public WorkItemStateListenerSupport(WorkItem workItem) {
        this.workItem = workItem;
    }

    public synchronized void addListener(WorkItemStateListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(WorkItemStateListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void fireDirtyStateChanged(boolean isDirty) {
        Iterator<WorkItemStateListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().dirtyStateChanged(isDirty, this.workItem);
        }
    }

    public synchronized void fireValidStateChanged(boolean isValid) {
        Iterator<WorkItemStateListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().validStateChanged(isValid, this.workItem);
        }
    }

    public synchronized void fireSaved() {
        Iterator<WorkItemStateListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().saved(this.workItem);
        }
    }

    public synchronized void fireSynchedToLatest() {
        Iterator<WorkItemStateListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().synchedToLatest(this.workItem);
        }
    }
}

