/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.fields.AllowedValuesCollection;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldType;
import com.microsoft.tfs.core.clients.workitem.fields.FieldUsages;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.AllowedValuesCollectionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.AllowedValuesHelper;
import com.microsoft.tfs.core.clients.workitem.internal.fields.DatastoreItemFieldUsage;
import com.microsoft.tfs.core.clients.workitem.internal.fields.DatastoreItemFieldUsagesCollection;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.FieldDefinitionMetadata;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverter;
import com.microsoft.tfs.core.clients.workitem.internal.type.WITypeConverterFactory;
import com.microsoft.tfs.core.clients.workitem.wittype.WorkItemType;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Date;

public class FieldDefinitionImpl
implements FieldDefinition {
    private final FieldDefinitionMetadata fieldDefinitionMetadata;
    private final WITypeConverter typeConverter;
    private AllowedValuesCollectionImpl allowedValues;
    private final WITContext context;
    private DatastoreItemFieldUsagesCollection fieldUsagesMetadata;
    private FieldUsages usage;
    private final int id;
    private final String referenceName;
    private final String name;
    private final FieldType fieldType;
    private final Class systemType;

    public FieldDefinitionImpl(WITContext context, FieldDefinitionMetadata fieldDefinitionMetadata, WorkItemType type, FieldUsages usage) {
        this.fieldDefinitionMetadata = fieldDefinitionMetadata;
        this.typeConverter = WITypeConverterFactory.getTypeConverter(this.getPSType());
        this.context = context;
        this.id = fieldDefinitionMetadata.getID();
        this.referenceName = fieldDefinitionMetadata.getReferenceName();
        this.name = fieldDefinitionMetadata.getName();
        this.usage = usage;
        this.fieldType = this.getTypeInternal();
        this.systemType = FieldDefinitionImpl.witFieldTypeToSystemType(this.getTypeInternal());
    }

    public int compareTo(Object o) {
        FieldDefinitionImpl other = (FieldDefinitionImpl)o;
        return this.fieldDefinitionMetadata.getName().compareToIgnoreCase(other.fieldDefinitionMetadata.getName());
    }

    public String toString() {
        return MessageFormat.format("{0}({1})", this.fieldDefinitionMetadata.getReferenceName(), Integer.toString(this.fieldDefinitionMetadata.getID()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public FieldType getFieldType() {
        if (this.fieldType == null) {
            throw new RuntimeException(MessageFormat.format("unknown field type [{0}] for field {1} (id {2})", this.fieldDefinitionMetadata.getType(), this.fieldDefinitionMetadata.getReferenceName(), Integer.toString(this.fieldDefinitionMetadata.getID())));
        }
        return this.fieldType;
    }

    @Override
    public boolean isQueryable() {
        if (this.isIgnored()) {
            return false;
        }
        int dataType = this.fieldDefinitionMetadata.getType() & 0xF0;
        return dataType == 16 || dataType == 32 || dataType == 48 || dataType == 64 || dataType == 160 || dataType == 224 || dataType == 240 || dataType == 208;
    }

    @Override
    public boolean isSortable() {
        return this.isQueryable() && (this.fieldDefinitionMetadata.getType() & 0xF0) != 64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllowedValuesCollection getAllowedValues() {
        FieldDefinitionImpl fieldDefinitionImpl = this;
        synchronized (fieldDefinitionImpl) {
            if (this.allowedValues == null) {
                AllowedValuesHelper helper = new AllowedValuesHelper(this.fieldDefinitionMetadata.getID(), this.fieldDefinitionMetadata.getType(), this.context);
                String[] values = helper.compute();
                this.allowedValues = new AllowedValuesCollectionImpl(values, this.getPSType());
            }
            return this.allowedValues;
        }
    }

    @Override
    public Class getSystemType() {
        return FieldDefinitionImpl.witFieldTypeToSystemType(this.getTypeInternal());
    }

    @Override
    public boolean isIndexed() {
        DatastoreItemFieldUsage metadata = this.context.getWorkItemFieldUsages().getUsageByFieldID(this.id);
        return metadata != null && metadata.isOftenQueried();
    }

    @Override
    public boolean isLongText() {
        FieldType type = this.getFieldType();
        return type == FieldType.PLAINTEXT || type == FieldType.HTML || type == FieldType.HISTORY;
    }

    @Override
    public boolean supportsTextQuery() {
        FieldDefinitionMetadata fieldMetadata = this.getFieldDefinitionMetadata();
        if (fieldMetadata.supportsTextQuery()) {
            return true;
        }
        DatastoreItemFieldUsage usageMetadata = this.context.getWorkItemFieldUsages().getUsageByFieldID(this.id);
        return usageMetadata != null && usageMetadata.supportsTextQuery();
    }

    public boolean isValidType(Object obj) {
        return this.getSystemType().isAssignableFrom(obj.getClass());
    }

    public boolean canCopy() {
        switch (this.fieldDefinitionMetadata.getID()) {
            case -4: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 22: 
            case 25: 
            case 32: 
            case 33: 
            case 54: {
                return false;
            }
        }
        if (this.isIgnored() || this.isReadonly()) {
            return false;
        }
        int storageType = this.fieldDefinitionMetadata.getType() & 0xF0;
        switch (storageType) {
            case 16: 
            case 32: 
            case 48: 
            case 64: 
            case 208: 
            case 224: 
            case 240: {
                return true;
            }
        }
        return false;
    }

    public boolean isUsedInPhysicalType() {
        int storageType = this.fieldDefinitionMetadata.getType() & 0xF0;
        switch (storageType) {
            case 16: 
            case 32: 
            case 48: 
            case 64: 
            case 160: 
            case 208: 
            case 224: 
            case 240: {
                return true;
            }
        }
        return false;
    }

    public int getPSType() {
        return this.fieldDefinitionMetadata.getType() & 0xFF0;
    }

    public int getInternalType() {
        return this.fieldDefinitionMetadata.getType();
    }

    public WITypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public boolean isIgnored() {
        return (this.fieldDefinitionMetadata.getType() & 2) > 0;
    }

    public boolean isReadonly() {
        return (this.fieldDefinitionMetadata.getType() & 1) > 0;
    }

    @Override
    public boolean isComputed() {
        return (this.fieldDefinitionMetadata.getType() & 1) > 0 || (this.fieldDefinitionMetadata.getType() & 0xF0) == 160;
    }

    public boolean isLargeText() {
        return (this.fieldDefinitionMetadata.getType() & 0xF0) == 64;
    }

    @Override
    public synchronized FieldUsages getUsage() {
        return this.usage;
    }

    public DatastoreItemFieldUsagesCollection getFieldUsageMetadata() {
        if (this.fieldUsagesMetadata == null) {
            this.fieldUsagesMetadata = new DatastoreItemFieldUsagesCollection(this.fieldDefinitionMetadata.getID(), this.context);
        }
        return this.fieldUsagesMetadata;
    }

    public FieldType getTypeInternal() {
        int psType = this.getPSType();
        switch (psType) {
            case 16: 
            case 24: 
            case 160: 
            case 528: 
            case 784: {
                return FieldType.STRING;
            }
            case 272: {
                return FieldType.TREEPATH;
            }
            case 32: 
            case 288: {
                return FieldType.INTEGER;
            }
            case 240: {
                return FieldType.DOUBLE;
            }
            case 48: {
                return FieldType.DATETIME;
            }
            case 64: {
                return FieldType.PLAINTEXT;
            }
            case 320: {
                return FieldType.HISTORY;
            }
            case 576: {
                return FieldType.HTML;
            }
            case 208: {
                return FieldType.GUID;
            }
            case 224: {
                return FieldType.BOOLEAN;
            }
        }
        return FieldType.STRING;
    }

    public static Class witFieldTypeToSystemType(FieldType fieldType) {
        if (fieldType == FieldType.STRING || fieldType == FieldType.PLAINTEXT || fieldType == FieldType.HTML || fieldType == FieldType.TREEPATH || fieldType == FieldType.HISTORY) {
            return String.class;
        }
        if (fieldType == FieldType.INTEGER) {
            return Integer.class;
        }
        if (fieldType == FieldType.DATETIME) {
            return Date.class;
        }
        if (fieldType == FieldType.DOUBLE) {
            return Double.class;
        }
        if (fieldType == FieldType.GUID) {
            return GUID.class;
        }
        if (fieldType == FieldType.BOOLEAN) {
            return Boolean.class;
        }
        return Object.class;
    }

    public FieldDefinitionMetadata getFieldDefinitionMetadata() {
        return this.fieldDefinitionMetadata;
    }

    public void setUsage(FieldUsages usage) {
        this.usage = usage;
    }
}

