/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.link;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkType;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEndCollection;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import java.util.Iterator;

public class WorkItemLinkTypeEndCollectionImpl
implements WorkItemLinkTypeEndCollection {
    private final HashMap<String, WorkItemLinkTypeEnd> mapByName = new HashMap();
    private final HashMap<Integer, WorkItemLinkTypeEnd> mapById = new HashMap();

    public WorkItemLinkTypeEndCollectionImpl(WITContext witContext, WorkItemLinkType[] linkTypes) {
        Check.notNull(witContext, "witContext");
        Check.notNullOrEmpty(linkTypes, "linkTypes");
        for (int i = 0; i < linkTypes.length; ++i) {
            WorkItemLinkType linkType = linkTypes[i];
            this.mapByName.put(linkType.getForwardEnd().getImmutableName(), linkType.getForwardEnd());
            this.mapByName.put(linkType.getForwardEnd().getName(), linkType.getForwardEnd());
            this.mapById.put(new Integer(linkType.getForwardEnd().getID()), linkType.getForwardEnd());
            if (!linkType.isDirectional()) continue;
            this.mapByName.put(linkType.getReverseEnd().getImmutableName(), linkType.getReverseEnd());
            this.mapByName.put(linkType.getReverseEnd().getName(), linkType.getReverseEnd());
            this.mapById.put(new Integer(linkType.getReverseEnd().getID()), linkType.getReverseEnd());
        }
    }

    @Override
    public boolean contains(int id) {
        return this.mapById.containsKey(new Integer(id));
    }

    @Override
    public boolean contains(String linkTypeName) {
        return this.mapByName.containsKey(linkTypeName);
    }

    @Override
    public WorkItemLinkTypeEnd get(String linkTypeEndName) {
        return this.mapByName.get(linkTypeEndName);
    }

    @Override
    public WorkItemLinkTypeEnd getByID(int id) {
        return this.mapById.get(new Integer(id));
    }

    @Override
    public int getCount() {
        return this.mapById.size();
    }

    @Override
    public Iterator<WorkItemLinkTypeEnd> iterator() {
        return this.mapById.values().iterator();
    }

    @Override
    public WorkItemLinkTypeEnd[] toArray(WorkItemLinkTypeEnd[] array) {
        return this.mapById.values().toArray(array);
    }
}

