/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.JwtCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.AuthorizationHeaderScheme;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import java.text.MessageFormat;

public class JwtAuthScheme
extends AuthorizationHeaderScheme {
    private boolean complete = false;

    @Override
    public boolean supportsCredentials(Credentials credentials) {
        return credentials instanceof JwtCredentials;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        this.complete = true;
    }

    @Override
    public String getSchemeName() {
        return "Bearer";
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    protected String authenticate(AuthScope authScope, Credentials credentials, HttpMethod method) throws AuthenticationException {
        return MessageFormat.format("Bearer {0}", ((JwtCredentials)credentials).getAccessToken());
    }
}

