/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.xml;

import com.microsoft.tfs.core.ws.runtime.types.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.base64.Base64;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class XMLConvert {
    private static final DateFormat UTC_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
    private static final DateFormat LOCAL_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static final DateFormat UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'Z'", Locale.US);
    private static final DateFormat LOCAL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-ddZ", Locale.US);
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");

    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    public static String toString(char value) {
        return Character.toString(value);
    }

    public static String toString(short value) {
        return Short.toString(value);
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static String toString(float value) {
        return Float.toString(value);
    }

    public static String toString(double value) {
        return Double.toString(value);
    }

    public static String toString(Calendar value, boolean includeTime) {
        return XMLConvert.toString(value, includeTime, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Calendar value, boolean includeTime, boolean toLocalFormat) {
        if (toLocalFormat) {
            String localFormat;
            DateFormat dateFormat;
            if (includeTime) {
                dateFormat = LOCAL_DATETIME_FORMAT;
                synchronized (dateFormat) {
                    localFormat = LOCAL_DATETIME_FORMAT.format(value.getTime());
                }
            }
            dateFormat = LOCAL_DATE_FORMAT;
            synchronized (dateFormat) {
                localFormat = LOCAL_DATE_FORMAT.format(value.getTime());
            }
            StringBuffer sb = new StringBuffer();
            sb.append(localFormat.substring(0, localFormat.length() - 2));
            sb.append(":");
            sb.append(localFormat.substring(localFormat.length() - 2, localFormat.length()));
            return sb.toString();
        }
        if (includeTime) {
            DateFormat dateFormat = UTC_DATETIME_FORMAT;
            synchronized (dateFormat) {
                return UTC_DATETIME_FORMAT.format(value.getTime());
            }
        }
        DateFormat dateFormat = UTC_DATE_FORMAT;
        synchronized (dateFormat) {
            return UTC_DATE_FORMAT.format(value.getTime());
        }
    }

    public static String toString(BigDecimal value) {
        return value.toString();
    }

    public static String toString(GUID value) {
        return value.toString();
    }

    public static short toShort(String value) {
        return Short.parseShort(value);
    }

    public static int toInt(String value) {
        return Integer.parseInt(value);
    }

    public static long toLong(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            return -1L;
        }
        return Long.parseLong(value);
    }

    public static float toFloat(String value) {
        return Float.parseFloat(value);
    }

    public static double toDouble(String value) {
        return Double.parseDouble(value);
    }

    public static boolean toBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static byte toByte(String value) {
        return Byte.parseByte(value);
    }

    public static char toCharacter(String value) {
        return value.charAt(0);
    }

    public static BigDecimal toBigDecimal(String value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value);
    }

    public static GUID toGUID(String value) {
        if (StringUtil.isNullOrEmpty(value)) {
            return null;
        }
        return new GUID(value);
    }

    public static final byte[] toByteArray(String value) {
        if (value == null) {
            return new byte[0];
        }
        try {
            return Base64.decodeBase64(value.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Calendar toCalendar(String value, boolean includeTime) {
        if (StringUtil.isNullOrEmpty(value)) {
            return null;
        }
        if (includeTime) {
            return XMLConvert.parseDateTime(value);
        }
        return XMLConvert.parseDate(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parseDate(String value) {
        Date date;
        Calendar calendar = Calendar.getInstance();
        boolean bc = false;
        if (value == null || value.length() == 0) {
            throw new NumberFormatException("Bad date value");
        }
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        if (value.charAt(0) == '-') {
            value = value.substring(1);
            bc = true;
        }
        if (value.length() < 10) {
            throw new NumberFormatException("Bad date value");
        }
        if (value.charAt(4) != '-' || value.charAt(7) != '-') {
            throw new NumberFormatException("bad date");
        }
        try {
            DateFormat dateFormat = UTC_DATE_FORMAT;
            synchronized (dateFormat) {
                date = UTC_DATE_FORMAT.parse(value.substring(0, 10) + "Z");
            }
        }
        catch (Exception e) {
            throw new NumberFormatException(e.toString());
        }
        int pos = 10;
        if (pos + 5 < value.length() && (value.charAt(pos) == '+' || value.charAt(pos) == '-')) {
            if (!(Character.isDigit(value.charAt(pos + 1)) && Character.isDigit(value.charAt(pos + 2)) && value.charAt(pos + 3) == ':' && Character.isDigit(value.charAt(pos + 4)) && Character.isDigit(value.charAt(pos + 5)))) {
                throw new NumberFormatException("bad time zone");
            }
            int hours = (value.charAt(pos + 1) - 48) * 10 + value.charAt(pos + 2) - 48;
            int mins = (value.charAt(pos + 4) - 48) * 10 + value.charAt(pos + 5) - 48;
            int milliseconds = (hours * 60 + mins) * 60 * 1000;
            if (value.charAt(pos) == '+') {
                milliseconds = -milliseconds;
            }
            date.setTime(date.getTime() + (long)milliseconds);
            pos += 6;
        }
        if (pos < value.length() && value.charAt(pos) == 'Z') {
            ++pos;
            calendar.setTimeZone(UTC_TIME_ZONE);
        }
        if (pos < value.length()) {
            throw new NumberFormatException("bad characters");
        }
        calendar.setTime(date);
        if (bc) {
            calendar.set(0, 0);
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parseDateTime(String value) {
        Date date;
        Calendar calendar = Calendar.getInstance();
        boolean bc = false;
        if (value == null || value.length() == 0) {
            throw new NumberFormatException("Bad datetime value");
        }
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        if (value.charAt(0) == '-') {
            value = value.substring(1);
            bc = true;
        }
        if (value.length() < 19) {
            throw new NumberFormatException("Bad datetime value");
        }
        if (value.charAt(4) != '-' || value.charAt(7) != '-' || value.charAt(10) != 'T') {
            throw new NumberFormatException("bad date");
        }
        if (value.charAt(13) != ':' || value.charAt(16) != ':') {
            throw new NumberFormatException("bad time");
        }
        try {
            DateFormat dateFormat = UTC_DATETIME_FORMAT;
            synchronized (dateFormat) {
                date = UTC_DATETIME_FORMAT.parse(value.substring(0, 19) + ".000Z");
            }
        }
        catch (Exception e) {
            throw new NumberFormatException(e.toString());
        }
        int pos = 19;
        if (pos < value.length() && value.charAt(pos) == '.') {
            int milliseconds = 0;
            int start = ++pos;
            while (pos < value.length() && Character.isDigit(value.charAt(pos))) {
                ++pos;
            }
            String decimal = value.substring(start, pos);
            if (decimal.length() == 3) {
                milliseconds = Integer.parseInt(decimal);
            } else if (decimal.length() < 3) {
                milliseconds = Integer.parseInt((decimal + "000").substring(0, 3));
            } else {
                milliseconds = Integer.parseInt(decimal.substring(0, 3));
                if (decimal.charAt(3) >= '5') {
                    ++milliseconds;
                }
            }
            date.setTime(date.getTime() + (long)milliseconds);
        }
        if (pos + 5 < value.length() && (value.charAt(pos) == '+' || value.charAt(pos) == '-')) {
            if (!(Character.isDigit(value.charAt(pos + 1)) && Character.isDigit(value.charAt(pos + 2)) && value.charAt(pos + 3) == ':' && Character.isDigit(value.charAt(pos + 4)) && Character.isDigit(value.charAt(pos + 5)))) {
                throw new NumberFormatException("bad time zone");
            }
            int hours = (value.charAt(pos + 1) - 48) * 10 + value.charAt(pos + 2) - 48;
            int mins = (value.charAt(pos + 4) - 48) * 10 + value.charAt(pos + 5) - 48;
            int milliseconds = (hours * 60 + mins) * 60 * 1000;
            if (value.charAt(pos) == '+') {
                milliseconds = -milliseconds;
            }
            date.setTime(date.getTime() + (long)milliseconds);
            pos += 6;
        }
        if (pos < value.length() && value.charAt(pos) == 'Z') {
            ++pos;
            calendar.setTimeZone(UTC_TIME_ZONE);
        }
        if (pos < value.length()) {
            throw new NumberFormatException("bad characters");
        }
        calendar.setTime(date);
        if (bc) {
            calendar.set(0, 0);
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        DateFormat dateFormat = UTC_DATETIME_FORMAT;
        synchronized (dateFormat) {
            UTC_DATETIME_FORMAT.setTimeZone(UTC_TIME_ZONE);
        }
        dateFormat = UTC_DATE_FORMAT;
        synchronized (dateFormat) {
            UTC_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
        }
    }
}

