/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.logging.config;

import com.microsoft.tfs.logging.config.DebugLogger;
import com.microsoft.tfs.logging.config.EnableReconfigurationPolicy;
import com.microsoft.tfs.logging.config.LoggingConfigurationProvider;
import com.microsoft.tfs.logging.config.ResetConfigurationPolicy;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;

public abstract class Config {
    public static void configure(LoggingConfigurationProvider provider, EnableReconfigurationPolicy enableReconfigurationPolicy, ResetConfigurationPolicy resetConfigurationPolicy) {
        if (provider == null) {
            throw new IllegalArgumentException("provider must not be null");
        }
        if (enableReconfigurationPolicy == null) {
            throw new IllegalArgumentException("enableReconfigurationPolicy must not be null");
        }
        if (resetConfigurationPolicy == null) {
            throw new IllegalArgumentException("resetConfigurationPolicy must not be null");
        }
        if (!enableReconfigurationPolicy.allowReconfiguration()) {
            DebugLogger.verbose(MessageFormat.format("skipping logging reconfiguration due to policy [{0}]", enableReconfigurationPolicy));
            return;
        }
        URL configurationURL = provider.getConfigurationURL();
        if (configurationURL == null) {
            DebugLogger.error(MessageFormat.format("logging configuration URL provided by [{0}] is null, not configuring", provider.getClass().getName()));
            return;
        }
        DebugLogger.verbose(MessageFormat.format("logging: reconfiguring logging with URL [{0}] provided by [{1}]", configurationURL, provider.getClass().getName()));
        LogManager.getLoggerRepository();
        if (resetConfigurationPolicy.resetConfiguration()) {
            DebugLogger.verbose(MessageFormat.format("logging: resetting existing logging configuration due to policy [{0}]", resetConfigurationPolicy));
            LogManager.resetConfiguration();
        }
        OptionConverter.selectAndConfigure((URL)configurationURL, null, (LoggerRepository)LogManager.getLoggerRepository());
    }
}

