/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ILenientScanner;
import eu.cqse.check.framework.scanner.IToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

abstract class QueuedScannerBase<E extends IToken>
implements ILenientScanner {
    private final Queue<E> queue = new LinkedList();

    QueuedScannerBase() {
    }

    public E getNextToken() throws IOException {
        if (!this.queue.isEmpty()) {
            return (E)((IToken)this.queue.poll());
        }
        return this.internalScan();
    }

    protected void pushToken(E token) {
        this.queue.add(token);
    }

    protected void pushTokens(E ... tokens) {
        this.queue.addAll(Arrays.asList(tokens));
    }

    protected void clearQueue() {
        this.queue.clear();
    }

    protected abstract E internalScan() throws IOException;
}

