/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.ITypeTracker;
import eu.cqse.check.framework.typetracker.PrecomputedTypeResolution;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class TypeTrackerBase
implements ITypeTracker {
    private static final EnumSet<EShallowEntityType> ORDERED_ENTITY_TYPES = EnumSet.of(EShallowEntityType.METHOD, EShallowEntityType.STATEMENT);
    private final ELanguage language;

    public TypeTrackerBase(ELanguage language) {
        this.language = language;
    }

    @Override
    public ITypeResolution createTypeResolution(List<ShallowEntity> rootEntities) {
        ScopedTypeLookup variableLookup = new ScopedTypeLookup(this.language.isCaseSensitive());
        return this.createTypeResolution(rootEntities, variableLookup);
    }

    @Override
    public ITypeResolution createTypeResolution(List<ShallowEntity> rootEntities, ScopedTypeLookup variableLookup) {
        this.initialize(rootEntities);
        ITypeInfoExtractor typeInfoExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor(this.language, rootEntities);
        this.addDefaultImports(variableLookup);
        return new PrecomputedTypeResolution(this.createTypeInformation(rootEntities, variableLookup, false, typeInfoExtractor));
    }

    private Map<ShallowEntity, ScopedTypeLookup> createTypeInformation(List<ShallowEntity> rootEntities, ScopedTypeLookup variableLookup, boolean ordered, ITypeInfoExtractor typeInfoExtractor) {
        HashMap<ShallowEntity, ScopedTypeLookup> typeLookups = new HashMap<ShallowEntity, ScopedTypeLookup>();
        this.createTypeInformation(rootEntities, variableLookup, ordered, typeLookups, typeInfoExtractor);
        return typeLookups;
    }

    private void createTypeInformation(List<ShallowEntity> entities, ScopedTypeLookup variableLookup, boolean ordered, Map<ShallowEntity, ScopedTypeLookup> typeLookups, ITypeInfoExtractor typeInfoExtractor) {
        for (ShallowEntity entity : entities) {
            UnmodifiableList children;
            boolean newTypeInfo;
            this.processImport(entity, variableLookup);
            List<TypedVariable> typeInfo = typeInfoExtractor.extract(entity);
            boolean bl = newTypeInfo = !typeInfo.isEmpty();
            if (ordered && newTypeInfo) {
                variableLookup = variableLookup.createChildScope();
            }
            ScopedTypeLookup currentLookup = variableLookup;
            if (newTypeInfo) {
                if (this.needsSeparateScope(entity)) {
                    currentLookup = currentLookup.createChildScope();
                }
                for (TypedVariable info : typeInfo) {
                    currentLookup.putTypeInfo(info.getVariableName(), info);
                }
            }
            typeLookups.put(entity, currentLookup);
            Optional<ShallowEntity> additionalParent = this.getAdditionalParent(entity);
            if (additionalParent.isPresent()) {
                currentLookup.addAddtitionalParent(typeLookups.get(additionalParent.get()));
            }
            if ((children = entity.getChildren()).isEmpty()) continue;
            this.createTypeInformation((List<ShallowEntity>)children, currentLookup.createChildScope(), this.needsOrderedScope(entity), typeLookups, typeInfoExtractor);
        }
    }

    protected void initialize(List<ShallowEntity> rootEntities) {
    }

    protected Optional<ShallowEntity> getAdditionalParent(ShallowEntity entity) {
        return Optional.empty();
    }

    protected void addDefaultImports(ScopedTypeLookup variableLookup) {
    }

    protected void processImport(ShallowEntity entity, ScopedTypeLookup variableLookup) {
    }

    protected boolean needsOrderedScope(ShallowEntity entity) {
        return ORDERED_ENTITY_TYPES.contains(entity.getType());
    }

    private boolean needsSeparateScope(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD || this.getSeparateScopeSubtypes().contains(entity.getSubtype());
    }

    protected abstract Set<String> getSeparateScopeSubtypes();
}

