/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.ObjectiveCLanguageFeatureParserBase;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ObjectiveCLanguageFeatureParser
extends ObjectiveCLanguageFeatureParserBase {
    private static final ITokenMatcher PRIMITIVE_TYPE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SIGNED, ETokenType.UNSIGNED, ETokenType.BOOL, ETokenType.CHAR, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE, ETokenType.VOID});
    private static final Set<String> GENERIC_EXCEPTION_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"NSException", "id"});
    private static final Set<String> UNCONDITIONAL_SWITCH_EXIT_STATEMENT_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"break", "return", "goto", "continue", "@throw", "abort", "exit", "_Exit", "__builtin_trap"});
    private static final Set<String> UNCONDITIONAL_NESTED_SWITCH_EXIT_STATEMENT_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"return", "@throw", "abort", "exit", "_Exit", "__builtin_trap"});

    ObjectiveCLanguageFeatureParser() {
        super(ELanguage.OBJECTIVE_C, PRIMITIVE_TYPE_TOKENS, new CLikeVariableUseExtractor((ITokenMatcher)ETokenType.DOT, VALID_IDENTIFIERS));
    }

    @Override
    public boolean isImport(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("@import");
    }

    public boolean isGenericExceptionClass(String className) {
        return GENERIC_EXCEPTION_NAMES.contains(className);
    }

    @Override
    public List<IToken> extractParameterTokens(List<IToken> methodStartTokens) {
        return ObjectiveCLanguageFeatureParser.extractObjectiveCParameterTokens(methodStartTokens);
    }

    public boolean isUnconditionalSwitchExit(ShallowEntity lastEntity, boolean isNestedSwitch) {
        if (lastEntity.getSubtype().equals("else")) {
            return this.isUnconditionalSwitchExitGivenElseAsLastEntity(lastEntity, isNestedSwitch);
        }
        return this.isCaseOrDefaultExitStatement(lastEntity, isNestedSwitch);
    }

    private boolean isUnconditionalSwitchExitGivenElseAsLastEntity(ShallowEntity lastEntity, boolean isNestedSwitch) {
        if (!this.isUnconditionalSwitchExit((List<ShallowEntity>)lastEntity.getChildren(), isNestedSwitch)) {
            return false;
        }
        UnmodifiableList siblings = lastEntity.getParent().getChildren();
        int index = siblings.indexOf(lastEntity);
        --index;
        while (index > 0 && "else if".equals(((ShallowEntity)siblings.get(index)).getSubtype())) {
            if (!this.isUnconditionalSwitchExit((List<ShallowEntity>)((ShallowEntity)siblings.get(index)).getChildren(), isNestedSwitch)) {
                return false;
            }
            --index;
        }
        return this.isUnconditionalSwitchExit((List<ShallowEntity>)((ShallowEntity)siblings.get(index)).getChildren(), isNestedSwitch);
    }

    private boolean isUnconditionalSwitchExit(List<ShallowEntity> entities, boolean isNestedSwitch) {
        return !entities.isEmpty() && this.isUnconditionalSwitchExit((ShallowEntity)CollectionUtils.getLast(entities), isNestedSwitch);
    }

    public boolean isCaseOrDefaultExitStatement(ShallowEntity entity, boolean isNestedSwitch) {
        return entity.getType() == EShallowEntityType.STATEMENT && entity.getSubtype().equals("simple statement") && ObjectiveCLanguageFeatureParser.getUnconditionalSwitchExitStatementNames(isNestedSwitch).contains(entity.getName());
    }

    private static Set<String> getUnconditionalSwitchExitStatementNames(boolean isNestedSwitch) {
        if (isNestedSwitch) {
            return UNCONDITIONAL_NESTED_SWITCH_EXIT_STATEMENT_NAMES;
        }
        return UNCONDITIONAL_SWITCH_EXIT_STATEMENT_NAMES;
    }

    public Optional<String> getSuperClassName(ShallowEntity entity) {
        int inheritanceSequenceIndex = TokenStreamUtils.firstTokenOfTypeSequence((List<IToken>)entity.ownStartTokens(), 0, ETokenType.COLON, ETokenType.IDENTIFIER);
        if (inheritanceSequenceIndex == -1 || entity.ownStartTokens().size() == inheritanceSequenceIndex + 1) {
            return Optional.empty();
        }
        return Optional.of(((IToken)entity.ownStartTokens().get(inheritanceSequenceIndex + 1)).getText());
    }

    @Override
    public Pair<List<IToken>, String> getModifiersAndReturnType(ShallowEntity method) {
        return this.getObjectiveCReturnTypeAndModifiers(method);
    }
}

