/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import java.lang.reflect.Field;

public class BooleanOptionDescriptor
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;

    public BooleanOptionDescriptor(ConfigExposed annotation, Field field) {
        super(annotation, field);
    }

    public BooleanOptionDescriptor(String name, String description, IConfigOptionDescriptorBehaviour behaviour) {
        super(name, description, false, behaviour);
    }

    @JsonCreator
    public BooleanOptionDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description) {
        super(name, description);
    }

    @Override
    protected Object parseValue(String optionValue) throws ProjectConfigurationException {
        return BooleanOptionDescriptor.parseBoolean(optionValue, this.getName());
    }

    public static boolean parseBoolean(String value, String nameForErrorReporting) throws ProjectConfigurationException {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new ProjectConfigurationException("Invalid value for boolean " + nameForErrorReporting + ": " + value);
    }
}

