/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings.metrics;

import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.findings.metrics.FindingsMetricBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class BlacklistCountMetric
extends FindingsMetricBase {
    public static final String BASE_NAME = "Number of %s Findings";
    private static final String BASE_DESCRIPTION = "The number of %s %sfindings";
    public static final BlacklistCountMetric TOLERATED = BlacklistCountMetric.tolerated(ETrafficLightColor.UNKNOWN);
    public static final BlacklistCountMetric TOLERATED_RED = BlacklistCountMetric.tolerated(ETrafficLightColor.RED);
    public static final BlacklistCountMetric TOLERATED_YELLOW = BlacklistCountMetric.tolerated(ETrafficLightColor.YELLOW);
    public static final BlacklistCountMetric FALSE_POSITIVE = BlacklistCountMetric.falsePositive(ETrafficLightColor.UNKNOWN);
    public static final BlacklistCountMetric FALSE_POSITIVE_RED = BlacklistCountMetric.falsePositive(ETrafficLightColor.RED);
    public static final BlacklistCountMetric FALSE_POSITIVE_YELLOW = BlacklistCountMetric.falsePositive(ETrafficLightColor.YELLOW);
    public static final BlacklistCountMetric COMPLETE = BlacklistCountMetric.all(ETrafficLightColor.UNKNOWN);
    public static final BlacklistCountMetric COMPLETE_RED = BlacklistCountMetric.all(ETrafficLightColor.RED);
    public static final BlacklistCountMetric COMPLETE_YELLOW = BlacklistCountMetric.all(ETrafficLightColor.YELLOW);

    private BlacklistCountMetric(String id, String name, String description, ETrafficLightColor color) {
        super(id, name, description, color);
    }

    private static BlacklistCountMetric tolerated(ETrafficLightColor color) {
        return BlacklistCountMetric.createBlacklistCountMetric("tolerated", color);
    }

    private static BlacklistCountMetric falsePositive(ETrafficLightColor color) {
        return BlacklistCountMetric.createBlacklistCountMetric("false positive", color);
    }

    private static BlacklistCountMetric all(ETrafficLightColor color) {
        return BlacklistCountMetric.createBlacklistCountMetric("flagged", "tolerated and false positive", color);
    }

    private static BlacklistCountMetric createBlacklistCountMetric(String readableName, ETrafficLightColor color) {
        return BlacklistCountMetric.createBlacklistCountMetric(readableName, readableName, color);
    }

    private static BlacklistCountMetric createBlacklistCountMetric(String readableName, String readableDescription, ETrafficLightColor color) {
        String baseName = String.format(BASE_NAME, readableName);
        String name = baseName + BlacklistCountMetric.getColorString(color, " (", ")", true);
        String id = BlacklistCountMetric.generateIdFromName(baseName, BlacklistCountMetric.getColorString(color));
        String description = String.format(BASE_DESCRIPTION, readableDescription, BlacklistCountMetric.getColorString(color, "", " "));
        return new BlacklistCountMetric(id, name, description, color);
    }

    @Override
    public void registerInSchema(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric(this.getId(), schema.createMetricIndexSource(this.getId()), this.getName(), this.getDescription(), EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, EMetricProperty.ARCHITECTURE_RELEVANT);
    }
}

