/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.teamscale.core.index.CommitResolver;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ImmutablePair;

public class CommitResolvingStorageSystem
extends ProjectStorageSystem {
    private final CommitResolver commitResolver;
    private final ConcurrentHashMap<ImmutablePair<Class<? extends IStorageIndex>, HistoryAccessOption>, HistoryAccessOption> cachedResolvedHistoryAccessOptions = new ConcurrentHashMap();
    private static final HistoryAccessOption HISTORY_ACCESS_OPTION_NULL = HistoryAccessOption.readHeadUnbranched();

    public CommitResolvingStorageSystem(IStorageSystem storageSystem, StorageCacheProvider.StorageSystemCacheProvider storageSystemCacheProvider, CommitResolver commitResolver, StorageCacheConfiguration cacheConfiguration) throws StorageException {
        super(storageSystem, storageSystemCacheProvider, cacheConfiguration);
        this.commitResolver = commitResolver;
    }

    public <T extends IProjectIndex> T openProjectIndex(Class<T> indexClass, HistoryAccessOption historyAccessOption) throws StorageException {
        return (T)super.openProjectIndex(indexClass, this.resolveHistoryAccessOptionCached(historyAccessOption, indexClass, Optional.empty()));
    }

    public <T extends IProjectIndexWithDynamicName> T openProjectIndex(Class<T> indexClass, String indexName, HistoryAccessOption historyAccessOption) throws StorageException {
        return (T)super.openProjectIndex(indexClass, indexName, this.resolveHistoryAccessOptionCached(historyAccessOption, indexClass, Optional.of(indexName)));
    }

    public HistoryAccessOption resolveHistoryAccessOptionCached(HistoryAccessOption historyAccessOption, Class<? extends IStorageIndex> indexClass, Optional<String> indexName) throws StorageException {
        if (!this.cacheConfiguration.cacheHistoryAccessOptions()) {
            return this.resolveHistoryAccessOption(historyAccessOption, indexClass, indexName);
        }
        ImmutablePair cacheKey = new ImmutablePair(indexClass, (Object)historyAccessOption);
        HistoryAccessOption cachedResult = this.cachedResolvedHistoryAccessOptions.get(cacheKey);
        if (cachedResult == HISTORY_ACCESS_OPTION_NULL) {
            return null;
        }
        if (cachedResult != null) {
            return cachedResult;
        }
        cachedResult = this.resolveHistoryAccessOption(historyAccessOption, indexClass, indexName);
        this.cachedResolvedHistoryAccessOptions.putIfAbsent((ImmutablePair<Class<? extends IStorageIndex>, HistoryAccessOption>)cacheKey, Objects.requireNonNullElse(cachedResult, HISTORY_ACCESS_OPTION_NULL));
        return cachedResult;
    }

    HistoryAccessOption resolveHistoryAccessOption(HistoryAccessOption historyAccessOption, Class<? extends IStorageIndex> indexClass, Optional<String> indexName) throws StorageException {
        if (historyAccessOption == null) {
            return null;
        }
        if (historyAccessOption.isUnbranched()) {
            return historyAccessOption;
        }
        if (historyAccessOption.isWriteMode()) {
            return historyAccessOption;
        }
        CommitDescriptor resolvedCommit = indexName.isPresent() ? this.commitResolver.resolveCommit(historyAccessOption, indexClass, indexName.get(), (ProjectStorageSystem)this) : this.commitResolver.resolveCommit(historyAccessOption, indexClass, (ProjectStorageSystem)this);
        return HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
    }
}

