/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.license;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

public class LicensedFeatureCollection<E extends Enum<E>> {
    private static final Logger LOGGER = LogManager.getLogger();
    @JsonProperty(value="features")
    private final Set<E> features;
    @JsonProperty(value="featuresAsString")
    private final String featuresAsString;
    private static final Comparator<Enum<?>> FEATURE_COMPARATOR = Comparator.comparing(String::valueOf);

    public LicensedFeatureCollection(Collection<E> features) {
        this.features = new HashSet<E>(features);
        this.featuresAsString = StringUtils.concat((Iterable)CollectionUtils.sort(features, FEATURE_COMPARATOR), (String)",");
    }

    public LicensedFeatureCollection(String descriptiveName, String featuresAsString, Class<E> enumType, List<String> errors) {
        this.featuresAsString = featuresAsString;
        this.features = LicensedFeatureCollection.parseEnumList(descriptiveName, featuresAsString, enumType, errors);
    }

    private static <T extends Enum<T>> Set<T> parseEnumList(String descriptiveName, String string, Class<T> enumType, List<String> errors) {
        EnumSet<T> values = EnumSet.noneOf(enumType);
        for (String stringValue : string.split(",")) {
            if (StringUtils.isEmpty((String)stringValue)) continue;
            Enum value = EnumUtils.valueOfIgnoreCase(enumType, (String)stringValue);
            if (value == null) {
                String message = descriptiveName + " " + StringUtils.toFirstUpper((String)stringValue) + " is licensed but not supported by this Teamscale version";
                LOGGER.error(message);
                errors.add(message);
                continue;
            }
            values.add(value);
        }
        return values;
    }

    public UnmodifiableSet<E> getFeatures() {
        return CollectionUtils.asUnmodifiable(this.features);
    }

    public String getFeaturesAsString() {
        return this.featuresAsString;
    }
}

