/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.MetricValueBase;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class AssessmentMetricValue
extends MetricValueBase<Assessment> {
    private static final long serialVersionUID = 1L;
    private static final Assessment GREEN_EMPTY_ASSESSMENT = new Assessment(ETrafficLightColor.GREEN);

    @JsonCreator
    public AssessmentMetricValue(@JsonProperty(value="schemaEntry") MetricDirectorySchemaEntry schemaEntry, @JsonProperty(value="value") Assessment value) {
        super(schemaEntry, value);
    }

    @Override
    public EMetricValueType getValueType() {
        return EMetricValueType.ASSESSMENT;
    }

    @Override
    protected double getPresentValueAsDouble(ETrafficLightColor color) {
        return AssessmentMetricValue.getRatio(((Assessment)this.getRawValue()).getColorFrequency(color), (Assessment)this.getRawValue());
    }

    @Override
    public Optional<Double> getValueAsDoubleForRating(ETrafficLightColor color) {
        if (!this.isValuePresent()) {
            return Optional.empty();
        }
        if (CommonUtils.isOneOf((Object)color, (Object[])new ETrafficLightColor[]{ETrafficLightColor.GREEN, ETrafficLightColor.RED})) {
            return this.getValueAsDouble(color);
        }
        if (color == ETrafficLightColor.YELLOW) {
            return Optional.of(this.getPresentValueAsDouble(ETrafficLightColor.YELLOW) + this.getPresentValueAsDouble(ETrafficLightColor.RED));
        }
        throw new IllegalArgumentException("Unsupported threshold color: " + String.valueOf(color));
    }

    @Override
    protected @Nullable MetricValueBase<Assessment> computeDelta(MetricValueBase<Assessment> baseValue) {
        Assessment value = new Assessment((Assessment)this.getOrDefault());
        value.subtract(baseValue.getOrDefault());
        return new AssessmentMetricValue(this.getSchemaEntry(), value);
    }

    private static double getRatio(int frequency, Assessment assessment) {
        if (assessment.getSize() == 0) {
            return 0.0;
        }
        return (double)frequency / (double)assessment.getSize();
    }
}

