/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.store;

import com.teamscale.core.migration.store.IMultiStoreMigrator;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.factory.IFactory;

class MultiStoreMigratingStorageSystem
implements IStorageSystem {
    private final IMultiStoreMigrator multiStoreMigrator;
    private final IStorageSystem targetStorageSystem;
    private final Map<String, IStore> temporaryInputStores;
    private final Map<String, IStore> temporaryOutputStores;

    public MultiStoreMigratingStorageSystem(IMultiStoreMigrator multiStoreMigrator, IStorageSystem targetStorageSystem, IFactory<IStore, StorageException> tempStoreFactory) throws StorageException {
        this.multiStoreMigrator = multiStoreMigrator;
        this.targetStorageSystem = targetStorageSystem;
        this.temporaryInputStores = new HashMap<String, IStore>();
        this.temporaryOutputStores = new HashMap<String, IStore>();
        for (String storeName : multiStoreMigrator.getInputStoreNames()) {
            this.temporaryInputStores.put(storeName, (IStore)tempStoreFactory.create());
        }
        for (String storeName : this.multiStoreMigrator.getOutputStoreNames()) {
            this.temporaryOutputStores.put(storeName, (IStore)tempStoreFactory.create());
        }
    }

    public void batchMigrate() throws StorageException {
        this.multiStoreMigrator.migrate(this.temporaryInputStores, this.temporaryOutputStores);
        for (String storeName : this.multiStoreMigrator.getOutputStoreNames()) {
            StorageUtils.copyStore((IStore)this.temporaryOutputStores.get(storeName), (IStore)this.targetStorageSystem.openStore(storeName));
        }
    }

    public IStore openStore(String name) throws StorageException {
        if (!this.temporaryInputStores.containsKey(name)) {
            throw new StorageException("Unknown store: " + name);
        }
        return this.temporaryInputStores.get(name);
    }

    public void removeStore(String storeName) {
        throw new UnsupportedOperationException();
    }

    public int getStorageSystemId() {
        throw new UnsupportedOperationException();
    }
}

