/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.DefaultGlobalRoles;
import com.teamscale.core.permissions.DefaultProjectRoles;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.RoleAssignment;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import com.teamscale.core.permissions.roles.RoleBase;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PermissionUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String SCOPE_PARAMETER_DESCRIPTION = "Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.";

    public static void assignAdminPermissions(ISubject subject, PermissionIndex permissionIndex) throws StorageException {
        permissionIndex.makeInstanceAdmin(subject);
        permissionIndex.assignGlobalProjectRole(subject, DefaultProjectRoles.PROJECT_ADMIN.getReadableName());
        for (EBasicPermissionScope permissionScope : EBasicPermissionScope.values()) {
            permissionIndex.assignGlobalBasicRole(subject, EBasicRole.OWNER.getReadableName(), permissionScope);
        }
    }

    public static void createDefaultRoles(PermissionIndex permissionIndex) throws StorageException {
        for (RoleBase role : DefaultGlobalRoles.CHANGEABLE_GLOBAL_ROLES) {
            permissionIndex.setGlobalRole((GlobalRole)role);
        }
        for (RoleBase role : DefaultProjectRoles.CHANGEABLE_PROJECT_ROLES) {
            permissionIndex.setProjectRole((ProjectRole)role);
        }
    }

    public static void assignGlobalRole(PermissionIndex permissionIndex, ISubject subject, GlobalRole globalRole) throws StorageException {
        permissionIndex.changeGlobalRoleAssignments(new RoleChange(subject, globalRole.getReadableName()));
    }

    public static void validateSubjectTypeAndId(ESubjectType subjectType, String subjectId, SupplierWithException<UserIndex, StorageException> userIndexFactory, SupplierWithException<UserGroupIndex, StorageException> groupIndexFactory, SupplierWithException<ProjectIndex, StorageException> projectIndexFactory) throws StorageException {
        switch (subjectType) {
            case USER: {
                if (((UserIndex)userIndexFactory.get()).getUser(subjectId) != null) break;
                throw new BadRequestException("User " + subjectId + " doesn't exist.");
            }
            case GROUP: {
                if (((UserGroupIndex)groupIndexFactory.get()).getUserGroup(subjectId) != null) break;
                throw new BadRequestException("Group " + subjectId + " doesn't exist.");
            }
            case PROJECT: {
                if (((ProjectIndex)projectIndexFactory.get()).resolveProject(IProjectId.getInstance((String)subjectId)) != null) break;
                throw new BadRequestException("Project " + subjectId + " doesn't exist.");
            }
            default: {
                CCSMAssert.fail((String)("Unknown subject type " + String.valueOf((Object)subjectType)));
            }
        }
    }

    public static void checkViewOrReadPermissionScopeForTargetSubject(ServicePermissions permissions, ESubjectType subjectType, String subjectId) throws StorageException {
        switch (subjectType) {
            case USER: {
                permissions.checkBasicPermission(EBasicPermissionScope.USERS, subjectId, EBasicPermission.VIEW);
                return;
            }
            case GROUP: {
                permissions.checkBasicPermission(EBasicPermissionScope.GROUPS, subjectId, EBasicPermission.VIEW);
                return;
            }
            case PROJECT: {
                permissions.checkReadInProject(IProjectId.getInstance((String)subjectId));
                return;
            }
        }
        CCSMAssert.fail((String)("Unknown subject type " + String.valueOf((Object)subjectType)));
    }

    public static <T> Set<T> getNestedSetSafe(Map<EBasicPermissionScope, Map<String, Set<T>>> nestedSetMap, EBasicPermissionScope permissionScope, String instanceId) {
        Map setMap = nestedSetMap.computeIfAbsent(permissionScope, k -> new HashMap());
        return setMap.computeIfAbsent(instanceId, k -> new HashSet());
    }

    private static boolean isInvalidRoleAssignment(RoleAssignment roleAssignment) {
        return roleAssignment.subjectType == ESubjectType.GROUP && roleAssignment.subjectId.equals("Administrators");
    }

    public static void checkRoleChange(RoleChange roleChange) throws BadRequestException {
        if (roleChange.addedRoles.stream().anyMatch(PermissionUtils::isInvalidRoleAssignment) || roleChange.removedRoles.stream().anyMatch(PermissionUtils::isInvalidRoleAssignment)) {
            throw new BadRequestException("Can't change role assignments of the group Administrators.");
        }
    }

    public static List<PublicProjectId> getVisibleProjectIds(GlobalStorageSystem globalStorageSystem, ServicePermissions permissions, List<PublicProjectId> projectIds) throws StorageException {
        List<PublicProjectId> projects = PermissionUtils.resolveToPrimaryPublicIds(projectIds, globalStorageSystem);
        List visibleProjects = CollectionUtils.map(permissions.getVisibleProjects(false, true), ProjectInfo::getPrimaryPublicId);
        if (projects.isEmpty()) {
            return visibleProjects;
        }
        HashSet visibleProjectsSet = new HashSet(visibleProjects);
        return CollectionUtils.filter(projects, visibleProjectsSet::contains);
    }

    private static List<PublicProjectId> resolveToPrimaryPublicIds(Collection<? extends IProjectId> projectIds, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)globalStorageSystem.openGlobalIndex(ProjectIndex.class);
        return CollectionUtils.mapWithException(projectIds, projectId -> {
            Optional<ProjectInfo> project = projectIndex.tryResolveProject((IProjectId)projectId);
            if (project.isPresent()) {
                return project.get().getPrimaryPublicId();
            }
            throw new NotFoundException("Project " + String.valueOf(projectId) + " doesn't exist or you don\u2019t have the necessary permissions!");
        });
    }

    public static void copyPermissions(UserGroupIndex groupIndex, PermissionIndex permissionIndex, String sourceGroupName, String targetGroupName) throws StorageException {
        boolean targetGroupExists;
        boolean sourceGroupExists;
        boolean bl = sourceGroupExists = groupIndex.getUserGroup(sourceGroupName) != null;
        if (!sourceGroupExists) {
            LOGGER.error("Cannot copy permissions from group '" + sourceGroupName + "', the group does not exist!");
            return;
        }
        boolean bl2 = targetGroupExists = groupIndex.getUserGroup(targetGroupName) != null;
        if (!targetGroupExists) {
            LOGGER.error("Cannot copy permissions to group '" + targetGroupName + "', the group does not exist!");
        }
        permissionIndex.moveOrCopyGroupPermissions(sourceGroupName, targetGroupName, false);
    }

    private PermissionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

