/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.List;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.branched.IHashingStore;
import org.conqat.lib.commons.collections.CollectionUtils;

public class DelegatingHashingStore
extends DelegatingStore
implements IHashingStore {
    private static final XXHash64 HASHER = XXHashFactory.fastestInstance().hash64();

    public DelegatingHashingStore(IStore delegate) {
        super(delegate);
    }

    public HashCode getHash(byte[] key) throws StorageException {
        return this.calculateHash(this.get(key));
    }

    public List<HashCode> getHash(List<byte[]> keys) throws StorageException {
        return CollectionUtils.map((Collection)this.get(keys), this::calculateHash);
    }

    public @NonNull HashCode calculateHash(byte[] value) {
        if (value == null) {
            return NULL;
        }
        return HashCode.fromLong((long)HASHER.hash(value, 0, value.length, 0L));
    }
}

