/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.google.common.base.Preconditions;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.util.BusyTimer;
import com.teamscale.core.runtime.impl.worker.WorkerJobExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class WorkerClusterStatus
implements Serializable {
    static final int MAX_TRIGGER_PARALLEL_THREADS = TeamscaleSystemProperties.MAX_TRIGGER_PARALLEL_THREADS.getValue();
    private static final long serialVersionUID = 1L;
    private final String processId;
    private final List<WorkerThreadStatus> threadStatuses = new ArrayList<WorkerThreadStatus>();
    private int jobQueueSize;
    private double schedulerLoad;
    private double workerLoad;
    private long lastRefreshed;
    private final transient Lock periodicJobSchedulingLock = new ReentrantLock();
    private final transient Lock deadConnectorCheckLock = new ReentrantLock();

    public WorkerClusterStatus(String processId) {
        this.processId = (String)Preconditions.checkNotNull((Object)processId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public WorkerThreadStatus createThreadStatus(String workerId) {
        WorkerThreadStatus workerThreadStatus = new WorkerThreadStatus(workerId);
        this.threadStatuses.add(workerThreadStatus);
        return workerThreadStatus;
    }

    public double getSchedulerLoad() {
        return this.schedulerLoad;
    }

    public double getWorkerLoad() {
        return this.workerLoad;
    }

    public int getWorkerCount() {
        return this.threadStatuses.size();
    }

    public int getJobQueueSize() {
        return this.jobQueueSize;
    }

    public List<WorkerThreadStatus> getThreadStatuses() {
        return this.threadStatuses;
    }

    public void prepareDataForPersistence(int jobQueueSize) {
        this.jobQueueSize = jobQueueSize;
        this.schedulerLoad = this.threadStatuses.stream().mapToDouble(threadStatus -> threadStatus.getSchedulingTimer().getUtilization()).sum();
        this.workerLoad = this.threadStatuses.stream().mapToDouble(threadStatus -> threadStatus.getOverallBusyTimer().getUtilization()).sum();
        this.lastRefreshed = System.currentTimeMillis();
    }

    public long getLastRefreshed() {
        return this.lastRefreshed;
    }

    Lock getPeriodicJobSchedulingLock() {
        return this.periodicJobSchedulingLock;
    }

    Lock getDeadConnectorCheckLock() {
        return this.deadConnectorCheckLock;
    }

    Optional<Pair<WorkerThreadStatus, Runnable>> findWorkerInNeedOfExecutionSupport(boolean ignoreMaxParallelThreadLimit) {
        for (WorkerThreadStatus threadStatus : this.threadStatuses) {
            Runnable task;
            if (!ignoreMaxParallelThreadLimit && threadStatus.supportingWorkers.get() + 1 >= MAX_TRIGGER_PARALLEL_THREADS || (task = threadStatus.offeredParallelTasks.poll()) == null) continue;
            return Optional.of(Pair.createPair((Object)threadStatus, (Object)task));
        }
        return Optional.empty();
    }

    @IndexValueClass
    public static class WorkerThreadStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String workerId;
        private final transient BusyTimer overallBusyTimer = new BusyTimer();
        private final transient BusyTimer schedulingTimer = new BusyTimer();
        private transient @Nullable WorkerJobExecutor currentExecutor;
        private transient @Nullable ScheduledJob scheduledJob;
        private final transient Deque<Runnable> offeredParallelTasks = new ConcurrentLinkedDeque<Runnable>();
        private PublicProjectId projectId;
        private String taskName;
        private CommitDescriptor commit;
        private @Nullable String supportedWorker;
        private long startTimestamp;
        private EWorkerThreadRunStatus runState = EWorkerThreadRunStatus.IDLE;
        private boolean cancelable;
        private final AtomicInteger supportingWorkers = new AtomicInteger();

        private WorkerThreadStatus(String workerId) {
            this.workerId = workerId;
        }

        public BusyTimer getOverallBusyTimer() {
            return this.overallBusyTimer;
        }

        public BusyTimer getSchedulingTimer() {
            return this.schedulingTimer;
        }

        public synchronized void startTask(PublicProjectId project, String task, CommitDescriptor commit, boolean cancelable) {
            this.startTimestamp = System.currentTimeMillis();
            this.projectId = project;
            this.taskName = task;
            this.commit = commit;
            this.runState = EWorkerThreadRunStatus.RUNNING;
            this.cancelable = cancelable;
        }

        public synchronized void clear() {
            this.projectId = null;
            this.taskName = null;
            this.commit = null;
            this.supportedWorker = null;
            this.runState = EWorkerThreadRunStatus.IDLE;
            this.cancelable = false;
            this.supportingWorkers.set(0);
        }

        public String getWorkerId() {
            return this.workerId;
        }

        public PublicProjectId getProjectId() {
            return this.projectId;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public CommitDescriptor getCommit() {
            return this.commit;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public void offerParallelTasks(Collection<? extends Runnable> tasks) {
            this.offeredParallelTasks.addAll(tasks);
        }

        public void participateInTaskExecution() {
            while (!this.offeredParallelTasks.isEmpty()) {
                Runnable nextTask = this.offeredParallelTasks.poll();
                if (nextTask == null) continue;
                nextTask.run();
            }
        }

        public @Nullable String getSupportedWorker() {
            return this.supportedWorker;
        }

        public void setSupportedWorker(String workerId) {
            this.startTimestamp = System.currentTimeMillis();
            this.supportedWorker = workerId;
        }

        public @Nullable WorkerJobExecutor getCurrentExecutor() {
            return this.currentExecutor;
        }

        public @Nullable ScheduledJob getScheduledJob() {
            return this.scheduledJob;
        }

        public EWorkerThreadRunStatus getRunState() {
            return this.runState;
        }

        synchronized void cancelTask(boolean interrupt) {
            CCSMAssert.isTrue((boolean)this.isCancelable(), (String)"Expected task to be cancelable");
            WorkerJobExecutor executor = this.currentExecutor;
            if (executor == null) {
                return;
            }
            this.runState = interrupt ? EWorkerThreadRunStatus.ABORTED : EWorkerThreadRunStatus.CANCELED;
            executor.cancelStep(interrupt);
        }

        public boolean isCancelable() {
            return this.cancelable;
        }

        public void setCurrentExecutorAndJob(WorkerJobExecutor currentExecutor, ScheduledJob scheduledJob) {
            this.currentExecutor = currentExecutor;
            this.scheduledJob = scheduledJob;
        }

        public void resetCurrentExecutorAndJob() {
            this.setCurrentExecutorAndJob(null, null);
        }

        public AtomicInteger getSupportingWorkers() {
            return this.supportingWorkers;
        }

        @IndexValueClass
        public static enum EWorkerThreadRunStatus {
            IDLE,
            RUNNING,
            CANCELED,
            ABORTED;

        }
    }
}

