/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.EBlockType;
import org.conqat.lib.simulink.builder.FlexiblePortPlacementParser;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.SimulinkModelBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.util.SimulinkJsonUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkPortBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final PairList<String, EPortType> PORT_TYPE_NAMES_IN_PORTCOUNTS_SECTION = PairList.fromPairs((Pair)Pair.createPair((Object)"in", (Object)((Object)EPortType.INPORT)), (Pair[])new Pair[]{Pair.createPair((Object)"out", (Object)((Object)EPortType.OUTPORT)), Pair.createPair((Object)"enable", (Object)((Object)EPortType.ENABLE)), Pair.createPair((Object)"trigger", (Object)((Object)EPortType.TRIGGER)), Pair.createPair((Object)"ifaction", (Object)((Object)EPortType.IFACTION)), Pair.createPair((Object)"state", (Object)((Object)EPortType.STATE)), Pair.createPair((Object)"reset", (Object)((Object)EPortType.RESET)), Pair.createPair((Object)"lconn", (Object)((Object)EPortType.LCONN)), Pair.createPair((Object)"rconn", (Object)((Object)EPortType.RCONN))});

    public static void buildPorts(SimulinkBlock simulinkBlock, MDLSection section) throws SimulinkModelBuildingException {
        List<Pair<Integer, EPortType>> portCounts = SimulinkPortBuilder.determinePortCounts(section.getFirstSubSection("PortCounts"), section.getParameter("Ports"), simulinkBlock);
        if (portCounts == null) {
            SimulinkPortBuilder.handleUndefinedPorts(simulinkBlock, section);
        } else {
            JsonNode flexiblePortPlacementSchema = SimulinkPortBuilder.parsePortSchemaParameter(section.getParameter("PortSchema"), simulinkBlock.getModel().getUniformPath());
            for (Pair<Integer, EPortType> portCountOfType : portCounts) {
                SimulinkPortBuilder.processPort((EPortType)((Object)portCountOfType.getSecond()), (Integer)portCountOfType.getFirst(), simulinkBlock, section, flexiblePortPlacementSchema);
            }
        }
        if (section.hasSubSections("PortProperties")) {
            SimulinkPortBuilder.readPortParametersFromPortPropertiesSection(simulinkBlock, section.getFirstSubSection("PortProperties"));
        } else {
            SimulinkPortBuilder.readPortParametersFromPortElements(simulinkBlock, section);
        }
    }

    private static void readPortParametersFromPortElements(SimulinkBlock simulinkBlock, MDLSection section) throws SimulinkModelBuildingException {
        for (MDLSection portSection : section.getSubSections("Port")) {
            String portTypeValue;
            String portNumber = portSection.getParameter("PortNumber");
            SimulinkPortBase port = SimulinkPortBuilder.findPortInBlock(simulinkBlock, portNumber, portTypeValue = portSection.getParameter("PortType"), section);
            if (port == null) {
                LOGGER.error("Error while adding parameters for port " + portTypeValue + "/" + portNumber + " in model " + simulinkBlock.getModel().getName());
                continue;
            }
            SimulinkModelBuilder.addParameters(port, portSection);
        }
    }

    private static void readPortParametersFromPortPropertiesSection(SimulinkBlock simulinkBlock, MDLSection portPropertiesSection) throws SimulinkModelBuildingException {
        for (MDLSection portSection : portPropertiesSection.getSubSections("Port")) {
            String portNumber = portSection.getParameter("Index");
            String portTypeValue = portSection.getParameter("Type");
            EPortType portType = EPortType.fromStringPortType(portTypeValue);
            String portKey = portType.createPortName(Integer.parseInt(portNumber));
            SimulinkPortBase port = portType.in ? simulinkBlock.getInPort(portKey) : simulinkBlock.getOutPort(portKey);
            if (port == null) {
                LOGGER.error("Error while adding parameters for port " + portTypeValue + "/" + portNumber + " in model " + simulinkBlock.getModel().getName());
                continue;
            }
            port.setParameter("PortNumber", portNumber);
            SimulinkModelBuilder.addParameters(port, portSection);
        }
    }

    private static @Nullable List<Pair<Integer, EPortType>> determinePortCounts(MDLSection portCountsSection, String portAttribute, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        if (portAttribute != null) {
            int[] portArray = SimulinkUtils.getIntParameterArray(portAttribute);
            ArrayList<Pair<Integer, EPortType>> portCounts = new ArrayList<Pair<Integer, EPortType>>();
            for (int i = 0; i < portArray.length; ++i) {
                EPortType.checkPortIndex(i, simulinkBlock);
                EPortType portType = EPortType.fromPortIndex(i);
                int portsOfType = portArray[i];
                portCounts.add((Pair<Integer, EPortType>)new Pair((Object)portsOfType, (Object)portType));
            }
            return portCounts;
        }
        if (portCountsSection != null) {
            ArrayList<Pair<Integer, EPortType>> portCounts = new ArrayList<Pair<Integer, EPortType>>();
            for (Pair portType : PORT_TYPE_NAMES_IN_PORTCOUNTS_SECTION) {
                String portTypeNameInSlxSection = (String)portType.getFirst();
                EPortType portTypeEnum = (EPortType)((Object)portType.getSecond());
                String portTypeCount = portCountsSection.getParameter(portTypeNameInSlxSection);
                if (portTypeCount == null) continue;
                int numberOfPorts = Integer.parseInt(portTypeCount);
                portCounts.add((Pair<Integer, EPortType>)new Pair((Object)numberOfPorts, (Object)portTypeEnum));
            }
            return portCounts;
        }
        return null;
    }

    private static SimulinkPortBase findPortInBlock(SimulinkBlock simulinkBlock, String portNumber, String portTypeValue, MDLSection section) throws SimulinkModelBuildingException {
        if (portTypeValue == null) {
            return simulinkBlock.getOutPort(portNumber);
        }
        int portIndex = Integer.parseInt(portTypeValue);
        if (SimulinkPortBuilder.isMechanicalModelPort(section.getParameter("Ports"))) {
            portIndex += 3;
        }
        EPortType.checkPortIndex(portIndex, simulinkBlock);
        EPortType portType = EPortType.fromPortIndex(portIndex);
        String portKey = portType.createPortName(Integer.parseInt(portNumber));
        if (portType.in) {
            return simulinkBlock.getInPort(portKey);
        }
        return simulinkBlock.getOutPort(portKey);
    }

    @VisibleForTesting
    public static JsonNode parsePortSchemaParameter(String portSchemaParameter, String uniformPath) {
        if (portSchemaParameter == null || portSchemaParameter.isEmpty()) {
            return null;
        }
        try {
            return SimulinkJsonUtils.parseJson(portSchemaParameter);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not parse \"PortSchema\" parameter of a block in model " + uniformPath + ". Ignoring the port schema.");
            return null;
        }
    }

    private static boolean isMechanicalModelPort(String portAttribute) {
        if (portAttribute == null) {
            return false;
        }
        return StringUtils.countCharacter((String)portAttribute, (char)',') >= 5;
    }

    private static void processPort(EPortType portType, int portCount, SimulinkBlock simulinkBlock, MDLSection section, JsonNode flexiblePortPlacementSchema) throws SimulinkModelBuildingException {
        if (portCount == 0) {
            return;
        }
        if (portCount > 1 && !portType.multiple) {
            throw new SimulinkModelBuildingException("Block " + String.valueOf(simulinkBlock) + " at " + String.valueOf(section) + " has " + portCount + " ports of type " + portType.name() + " whereas only one is supported.");
        }
        int currentPortsSize = (int)simulinkBlock.getOutPorts().stream().filter(port -> port.getPortType() == portType).count();
        if (portType.in) {
            currentPortsSize = (int)simulinkBlock.getInPorts().stream().filter(port -> port.getPortType() == portType).count();
        }
        for (int i = 1 + currentPortsSize; i <= portCount + currentPortsSize; ++i) {
            SimulinkPortBuilder.addPort(simulinkBlock, portType, i, flexiblePortPlacementSchema);
        }
    }

    private static void addPort(SimulinkBlock simulinkBlock, EPortType portType, int portNumber, JsonNode flexiblePortPlacementSchema) {
        FlexiblePortPlacementParameters flexiblePortPlacementParameters = FlexiblePortPlacementParser.getSimulinkPortSchemaEntryForPort(portType, portNumber, flexiblePortPlacementSchema, simulinkBlock);
        if (portType.in) {
            new SimulinkInPort(simulinkBlock, portType, portType.createPortName(portNumber), flexiblePortPlacementParameters);
        } else {
            new SimulinkOutPort(simulinkBlock, portType, portType.createPortName(portNumber), flexiblePortPlacementParameters);
        }
    }

    private static void handleUndefinedPorts(SimulinkBlock simulinkBlock, MDLSection section) {
        int i;
        EBlockType knownBlockType = (EBlockType)EnumUtils.valueOf(EBlockType.class, (String)section.getParameter("BlockType"));
        if (knownBlockType == null) {
            new SimulinkInPort(simulinkBlock, EPortType.INPORT, "1", null);
            new SimulinkOutPort(simulinkBlock, EPortType.OUTPORT, "1", null);
            return;
        }
        for (i = 1; i <= knownBlockType.getNumInPorts(); ++i) {
            new SimulinkInPort(simulinkBlock, EPortType.INPORT, String.valueOf(i), null);
        }
        for (i = 1; i <= knownBlockType.getNumOutPorts(); ++i) {
            new SimulinkOutPort(simulinkBlock, EPortType.OUTPORT, String.valueOf(i), null);
        }
    }

    public static enum EPortType {
        INPORT(true, true),
        OUTPORT(true, false),
        ENABLE(false, true),
        TRIGGER(false, true),
        STATE(false, false),
        LCONN(true, true),
        RCONN(true, false),
        IFACTION(false, true),
        RESET(false, true);

        private final boolean multiple;
        private final boolean in;

        private EPortType(boolean multiple, boolean in) {
            this.multiple = multiple;
            this.in = in;
        }

        private String createPortName(int portNumber) {
            if (this == LCONN || this == RCONN) {
                return this.name().toLowerCase() + ":" + portNumber;
            }
            if (this.multiple) {
                return String.valueOf(portNumber);
            }
            if (this == RESET) {
                return "Reset";
            }
            return this.name().toLowerCase();
        }

        private static EPortType fromPortIndex(int portIndex) {
            return EPortType.values()[portIndex];
        }

        private static void checkPortIndex(int portTypeIndex, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
            if (portTypeIndex < 0 || portTypeIndex >= EPortType.values().length) {
                throw new SimulinkModelBuildingException("Block " + String.valueOf(simulinkBlock) + " has an unknown port with index " + portTypeIndex);
            }
        }

        private static EPortType fromStringPortType(String portType) throws SimulinkModelBuildingException {
            for (Pair portTypeIdentifier : PORT_TYPE_NAMES_IN_PORTCOUNTS_SECTION) {
                if (!((String)portTypeIdentifier.getFirst()).equals(portType)) continue;
                return (EPortType)((Object)portTypeIdentifier.getSecond());
            }
            throw new SimulinkModelBuildingException("Unknown port type " + portType);
        }
    }
}

