/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;

class SlxFileContentProvider
implements ISimulinkFileContentProvider {
    private final Map<String, byte[]> data = new HashMap<String, byte[]>();

    public SlxFileContentProvider(byte[] content) throws SimulinkModelBuildingException {
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(content));){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                this.data.put(entry.getName(), FileSystemUtils.readStreamBinary((InputStream)zis));
                entry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new SimulinkModelBuildingException(e);
        }
    }

    @Override
    public boolean isMultiFileContainer() {
        return true;
    }

    @Override
    public List<String> listContainedFilenames() {
        return CollectionUtils.sort(this.data.keySet());
    }

    @Override
    public Optional<String> getNamedContent(String name) {
        return this.getNamedBinaryContent(name).map(StringUtils::bytesToString);
    }

    @Override
    public Optional<byte[]> getNamedBinaryContent(String name) {
        return Optional.ofNullable(this.data.get(name));
    }
}

