/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.awt.image.BufferedImage;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.datahandler.AnnotationLayoutData;
import org.conqat.lib.simulink.model.datahandler.EInterpreter;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;

public class SimulinkAnnotation
extends SimulinkElementBase {
    private static final String IMAGE_PATH = "ImagePath";
    private static final String ANONYMOUS_ANNOTATION_NAME = "<unnamed annotation>";

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            return ANONYMOUS_ANNOTATION_NAME;
        }
        return name;
    }

    @Override
    String getDefaultParameter(String name) {
        return this.getModel().getAnnotationDefaultParameter(name);
    }

    @Override
    Set<String> getDefaultParameterNames() {
        return this.getModel().getAnnotationDefaultParameterNames();
    }

    @SimulinkTestExclude
    public AnnotationLayoutData obtainLayoutData() {
        return this.getModel().getModelDataHandler().getSimulinkLayoutHandler().obtainAnnotationLayoutData(this);
    }

    @SimulinkTestExclude
    public LabelLayoutData obtainLabelData() {
        return this.getModel().getModelDataHandler().getSimulinkLayoutHandler().obtainAnnotationLabelData(this);
    }

    public boolean containsImage() {
        return this.getParameter(IMAGE_PATH) != null;
    }

    public @Nullable BufferedImage getImage() {
        String path = this.getParameter(IMAGE_PATH);
        if (path == null) {
            return null;
        }
        path = path.replace("[$unpackedFolder]", "");
        return this.getModel().getImage(path);
    }

    @SimulinkTestExclude
    public EInterpreter getInterpreter() {
        return EInterpreter.getFromValue(this.getParameter("Interpreter"));
    }

    public String buildQualifiedName() {
        SimulinkElementBase parent = this.getParent();
        String sid = this.getParameter("SID");
        if (parent != null) {
            return parent.getId() + "/" + sid;
        }
        return sid;
    }
}

