/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.metadata.abap.EAbapProgramType;
import eu.cqse.check.abap.MissingAuthorityCheckInObjectBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-missing-authority-check-in-report", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingAuthorityCheckInReportCheck
extends MissingAuthorityCheckInObjectBase {
    private static final String CHECK_NAME = "Missing AUTHORITY-CHECK in reports/programs";
    private static final String FINDINGS_MESSAGE = "Missing authority check at start of program";
    @CheckOption(name="Missing AUTHORITY-CHECK in reports/programs - Alternative authority check statements", description="Comma separated list (regular expressions) for alternative authority check statements, e.g. call to custom methods which encapsulate AUTHORITY-CHECK.")
    private Set<String> alternativeAuthorityChecks = Collections.emptySet();
    @CheckOption(name="Missing AUTHORITY-CHECK in reports/programs - only if no auth group", description="If enabled, only creates findings for reports that have no authorization group set.")
    private boolean onlyReportIfNoAuthGroupSet = false;

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!type.getSubtype().equals("report") && !type.getSubtype().equals("program")) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (!this.isExecutableProgram()) {
            return;
        }
        if (this.onlyReportIfNoAuthGroupSet && this.isAuthGroupSet()) {
            return;
        }
        if (this.checkInitializationBlocks() || this.checkStartOfSelectionBlocks()) {
            return;
        }
        this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forLine(entity.getStartLine())).createAndStore();
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private boolean isExecutableProgram() {
        return this.context.getMetadataOfType(AbapFileMetadata.class).map(AbapFileMetadata::getProgramType).map(type -> type == EAbapProgramType.EXECUTABLE_PROGRAM).orElse(true);
    }

    private boolean isAuthGroupSet() {
        return this.context.getMetadataOfType(AbapFileMetadata.class).map(AbapFileMetadata::getAuthorizationGroup).map(group -> !StringUtils.isEmpty((String)group)).orElse(false);
    }

    private boolean checkInitializationBlocks() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("initialization")) continue;
            return this.isStartingWithAuthorityCheck(method);
        }
        return false;
    }

    private boolean checkStartOfSelectionBlocks() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!method.getSubtype().equals("start-of-selection")) continue;
            if (!this.isStartingWithAuthorityCheck(method)) {
                this.buildFinding(FINDINGS_MESSAGE, this.buildLocation().forLine(method.getStartLine())).createAndStore();
            }
            return true;
        }
        return false;
    }

    @Override
    protected Set<String> getAlternativeAuthorityChecksOption() {
        return this.alternativeAuthorityChecks;
    }
}

