/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class MemberVisibilityOrderCheckBase
extends CheckImplementationBase {
    protected final List<ETokenType> MODIFIER_ORDER = this.getOrderedModifier();

    protected abstract List<ETokenType> getOrderedModifier();

    public void execute() throws CheckException {
        for (ShallowEntity entity : this.select(this.getClassEntitiesXPath())) {
            PairList<ETokenType, ShallowEntity> members = this.getMembersVisibilityOrder(entity);
            int currentModifierIndex = 0;
            for (Pair member : members) {
                ETokenType modifier = (ETokenType)member.getFirst();
                int modifierIndex = this.MODIFIER_ORDER.indexOf(modifier);
                if (modifierIndex >= currentModifierIndex) {
                    currentModifierIndex = modifierIndex;
                    continue;
                }
                Optional<String> findingMessage = this.getFindingsMessage((Pair<ETokenType, ShallowEntity>)member, this.MODIFIER_ORDER.get(currentModifierIndex));
                findingMessage.ifPresent(msg -> this.buildFinding((String)msg, this.buildLocation().forEntity((ShallowEntity)member.getSecond())).createAndStore());
            }
        }
    }

    protected Optional<String> getFindingsMessage(Pair<ETokenType, ShallowEntity> member, ETokenType precedingModifier) {
        if (((ShallowEntity)member.getSecond()).getName() == null) {
            return Optional.empty();
        }
        String tokenType = MarkupUtils.escapeMarkdownRelevantSymbols((String)((ETokenType)member.getFirst()).toString().toLowerCase());
        String memberString = MarkupUtils.formatAsSourceCode((String)((ShallowEntity)member.getSecond()).getName());
        String precedingModifierString = MarkupUtils.escapeMarkdownRelevantSymbols((String)precedingModifier.toString().toLowerCase());
        return Optional.of(tokenType + " member " + memberString + " should not occur after " + precedingModifierString + " member. Expected order: " + MemberVisibilityOrderCheckBase.getOrderString(this.MODIFIER_ORDER));
    }

    private PairList<ETokenType, ShallowEntity> getMembersVisibilityOrder(ShallowEntity classEntity) throws CheckException {
        List members = MemberVisibilityOrderCheckBase.select((ShallowEntity)classEntity, (String)this.getMemberXPathSelection());
        PairList pairList = new PairList();
        for (ShallowEntity member : members) {
            pairList.add((Object)this.getAccessModifierFromMember(member), (Object)member);
        }
        return pairList;
    }

    protected @Nullable ETokenType getAccessModifierFromMember(ShallowEntity member) {
        ETokenType firstType;
        UnmodifiableList tokens = member.ownStartTokens();
        if (!tokens.isEmpty() && this.MODIFIER_ORDER.contains(firstType = ((IToken)tokens.get(0)).getType())) {
            return firstType;
        }
        return null;
    }

    protected String getMemberXPathSelection() {
        return "./ATTRIBUTE";
    }

    protected String getClassEntitiesXPath() {
        return "//TYPE[subtype('class')]";
    }

    protected static String getOrderString(List<ETokenType> list) {
        return list.stream().map(x -> x.toString().toLowerCase()).collect(Collectors.joining(", "));
    }
}

