/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-whitespace-formatting", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={})
public class WhitespaceFormattingCheck
extends CheckImplementationBase {
    @CheckOption(name="Do not use tabs", description="Mark use of tabulator characters")
    private boolean checkTabs = true;
    @CheckOption(name="Do not use trailing spaces", description="Mark spaces behind the last visible character of a line. These spaces are not visible in editors.")
    private boolean checkSpaces = true;
    @CheckOption(name="File must end with a linebreak", description="Files that do not end with a linebreak can confuse programs")
    private boolean checkEndLineBreak = true;

    public void execute() throws CheckException {
        if (this.checkTabs || this.checkSpaces) {
            List lines = StringUtils.splitLinesAsList((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT));
            for (int i = 0; i < lines.size(); ++i) {
                if (this.checkTabs && ((String)lines.get(i)).contains("\t")) {
                    this.buildFinding("Tab Character violates Coding Guideline", this.buildLocation().forLine(i + 1)).createAndStore();
                }
                if (!this.checkSpaces || !((String)lines.get(i)).endsWith(" ")) continue;
                this.buildFinding("Trailing Whitespace in Line", this.buildLocation().forLine(i + 1)).createAndStore();
            }
        }
        if (this.checkEndLineBreak && !this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT).endsWith("\n")) {
            this.buildFinding("No Linebreak at End of File", this.buildLocation().forElement()).createAndStore();
        }
    }
}

