/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ambiguous_language.AmbiguousLanguageResolutionUtils;
import java.util.Set;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-cpp-inconsistent-extension", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, groupName="Naming")
public class CppInconsistentExtensionCheck
extends CheckImplementationBase {
    @CheckOption(name="Expected C++ File Extensions", description="Extensions that every file containing C++ code is expected to have")
    private Set<String> expectedExtensions = Sets.newHashSet((Object[])new String[]{"cpp", "cc", "cxx", "h", "hpp", "hh"});
    private String message;

    public void initialize() throws CheckException {
        super.initialize();
        this.message = String.format("C++ source files and headers should use file extensions specific to C++: %s", StringUtils.concat(this.expectedExtensions, (String)", "));
    }

    public void execute() throws CheckException {
        String fileExtension = FileSystemUtils.getFileExtension((String)this.context.getUniformPath());
        boolean inconsistentExtension = fileExtension == null || !this.expectedExtensions.contains(fileExtension);
        ELanguage decidedLanguage = AmbiguousLanguageResolutionUtils.decideForAmbiguousLanguage(Set.of(ELanguage.C, ELanguage.CPP), (String)this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT));
        if (inconsistentExtension && decidedLanguage == ELanguage.CPP) {
            this.buildFinding(this.message, this.buildLocation().forElement()).createAndStore();
        }
    }
}

